/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.client.migration.InvokersChangedListener;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.RouterChain;
import org.apache.dubbo.rpc.cluster.RouterFactory;
import org.apache.dubbo.rpc.cluster.directory.AbstractDirectory;

public abstract class DynamicDirectory<T>
extends AbstractDirectory<T>
implements NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDirectory.class);
    protected final Cluster cluster;
    protected final RouterFactory routerFactory;
    protected final String serviceKey;
    protected final Class<T> serviceType;
    protected final URL directoryUrl;
    protected final boolean multiGroup;
    protected Protocol protocol;
    protected Registry registry;
    protected volatile boolean forbidden = false;
    protected boolean shouldRegister;
    protected boolean shouldSimplified;
    protected volatile URL overrideDirectoryUrl;
    protected volatile URL subscribeUrl;
    protected volatile URL registeredConsumerUrl;
    protected volatile List<Configurator> configurators;
    protected volatile List<Invoker<T>> invokers;
    protected ServiceInstancesChangedListener serviceListener;
    private volatile InvokersChangedListener invokersChangedListener;
    private volatile boolean invokersChanged;

    public DynamicDirectory(Class<T> serviceType, URL url) {
        super(url, true);
        this.cluster = url.getOrDefaultApplicationModel().getExtensionLoader(Cluster.class).getAdaptiveExtension();
        this.routerFactory = url.getOrDefaultApplicationModel().getExtensionLoader(RouterFactory.class).getAdaptiveExtension();
        if (serviceType == null) {
            throw new IllegalArgumentException("service type is null.");
        }
        if (url.getServiceKey() == null || url.getServiceKey().length() == 0) {
            throw new IllegalArgumentException("registry serviceKey is null.");
        }
        this.shouldRegister = !"*".equals(url.getServiceInterface()) && url.getParameter("register", true);
        this.shouldSimplified = url.getParameter("simplified", false);
        this.serviceType = serviceType;
        this.serviceKey = super.getConsumerUrl().getServiceKey();
        this.overrideDirectoryUrl = this.directoryUrl = this.consumerUrl;
        String group = this.directoryUrl.getGroup("");
        this.multiGroup = group != null && ("*".equals(group) || group.contains(","));
    }

    @Override
    public void addServiceListener(ServiceInstancesChangedListener instanceListener) {
        this.serviceListener = instanceListener;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public boolean isShouldRegister() {
        return this.shouldRegister;
    }

    public void subscribe(URL url) {
        this.setSubscribeUrl(url);
        this.registry.subscribe(url, this);
    }

    public void unSubscribe(URL url) {
        this.setSubscribeUrl(null);
        this.registry.unsubscribe(url, this);
    }

    @Override
    public List<Invoker<T>> doList(Invocation invocation) {
        if (this.forbidden) {
            throw new RpcException(4, "No provider available from registry " + this.getUrl().getAddress() + " for service " + this.getConsumerUrl().getServiceKey() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + ", please check status of providers(disabled, not registered or in blacklist).");
        }
        if (this.multiGroup) {
            return this.invokers == null ? Collections.emptyList() : this.invokers;
        }
        List invokers = null;
        try {
            invokers = this.routerChain.route(this.getConsumerUrl(), invocation);
        }
        catch (Throwable t) {
            logger.error("Failed to execute router: " + this.getUrl() + ", cause: " + t.getMessage(), t);
        }
        return invokers == null ? Collections.emptyList() : invokers;
    }

    @Override
    public Class<T> getInterface() {
        return this.serviceType;
    }

    @Override
    public List<Invoker<T>> getAllInvokers() {
        return this.invokers == null ? Collections.emptyList() : this.invokers;
    }

    @Override
    public URL getConsumerUrl() {
        return this.overrideDirectoryUrl;
    }

    public URL getOriginalConsumerUrl() {
        return this.overrideDirectoryUrl;
    }

    public URL getRegisteredConsumerUrl() {
        return this.registeredConsumerUrl;
    }

    public URL getSubscribeUrl() {
        return this.subscribeUrl;
    }

    public void setSubscribeUrl(URL subscribeUrl) {
        this.subscribeUrl = subscribeUrl;
    }

    public void setRegisteredConsumerUrl(URL url) {
        this.registeredConsumerUrl = !this.shouldSimplified ? url.addParameters("category", "consumers", "check", String.valueOf(false)) : URL.valueOf(url, InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_CONSUMER_KEYS, null).addParameters("category", "consumers", "check", String.valueOf(false));
    }

    public void buildRouterChain(URL url) {
        this.setRouterChain(RouterChain.buildChain(url));
    }

    public List<Invoker<T>> getInvokers() {
        return this.invokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            if (this.getRegisteredConsumerUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unregister(this.getRegisteredConsumerUrl());
            }
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unregister service " + this.serviceKey + " from registry: " + this.registry.getUrl(), t);
        }
        try {
            if (this.getSubscribeUrl() != null && this.registry != null && this.registry.isAvailable()) {
                this.registry.unsubscribe(this.getSubscribeUrl(), this);
            }
        }
        catch (Throwable t) {
            logger.warn("unexpected error when unsubscribe service " + this.serviceKey + " from registry: " + this.registry.getUrl(), t);
        }
        ExtensionLoader<AddressListener> addressListenerExtensionLoader = this.getUrl().getOrDefaultModuleModel().getExtensionLoader(AddressListener.class);
        List<AddressListener> supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                addressListener.destroy(this.getConsumerUrl(), this);
            }
        }
        DynamicDirectory dynamicDirectory = this;
        synchronized (dynamicDirectory) {
            try {
                this.destroyAllInvokers();
            }
            catch (Throwable t) {
                logger.warn("Failed to destroy service " + this.serviceKey, t);
            }
            this.routerChain.destroy();
            this.invokersChangedListener = null;
            this.serviceListener = null;
            super.destroy();
        }
    }

    @Override
    public void discordAddresses() {
        try {
            this.destroyAllInvokers();
        }
        catch (Throwable t) {
            logger.warn("Failed to destroy service " + this.serviceKey, t);
        }
    }

    public synchronized void setInvokersChangedListener(InvokersChangedListener listener) {
        this.invokersChangedListener = listener;
        if (this.invokersChangedListener != null && this.invokersChanged) {
            this.invokersChangedListener.onChange();
        }
    }

    protected synchronized void invokersChanged() {
        this.invokersChanged = true;
        if (this.invokersChangedListener != null) {
            this.invokersChangedListener.onChange();
            this.invokersChanged = false;
        }
    }

    @Override
    public boolean isNotificationReceived() {
        return this.invokersChanged;
    }

    protected abstract void destroyAllInvokers();
}

