/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.support;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceDiscoveryRegistry;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class RegistryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryManager.class);
    private ApplicationModel applicationModel;
    private final Map<String, Registry> registries = new ConcurrentHashMap<String, Registry>();
    protected final ReentrantLock lock = new ReentrantLock();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private static final Registry DEFAULT_NOP_REGISTRY = new Registry(){

        @Override
        public URL getUrl() {
            return null;
        }

        @Override
        public boolean isAvailable() {
            return false;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void register(URL url) {
        }

        @Override
        public void unregister(URL url) {
        }

        @Override
        public void subscribe(URL url, NotifyListener listener) {
        }

        @Override
        public void unsubscribe(URL url, NotifyListener listener) {
        }

        @Override
        public List<URL> lookup(URL url) {
            return null;
        }
    };

    public RegistryManager(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public Collection<Registry> getRegistries() {
        return Collections.unmodifiableCollection(new LinkedList<Registry>(this.registries.values()));
    }

    public Registry getRegistry(String key) {
        return this.registries.get(key);
    }

    public void putRegistry(String key, Registry registry) {
        this.registries.put(key, registry);
    }

    public List<ServiceDiscovery> getServiceDiscoveries() {
        return this.getRegistries().stream().filter(registry -> registry instanceof ServiceDiscoveryRegistry).map(registry -> (ServiceDiscoveryRegistry)registry).map(ServiceDiscoveryRegistry::getServiceDiscovery).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyAll() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Close all registries " + this.getRegistries());
        }
        this.lock.lock();
        try {
            for (Registry registry : this.getRegistries()) {
                try {
                    registry.destroy();
                }
                catch (Throwable e) {
                    LOGGER.warn(e.getMessage(), e);
                }
            }
            this.registries.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void reset() {
        this.destroyed.set(false);
        this.registries.clear();
    }

    protected Registry getDefaultNopRegistryIfDestroyed() {
        if (this.destroyed.get()) {
            LOGGER.warn("All registry instances have been destroyed, failed to fetch any instance. Usually, this means no need to try to do unnecessary redundant resource clearance, all registries has been taken care of.");
            return DEFAULT_NOP_REGISTRY;
        }
        return null;
    }

    protected Lock getRegistryLock() {
        return this.lock;
    }

    public void removeDestroyedRegistry(Registry toRm) {
        this.lock.lock();
        try {
            this.registries.entrySet().removeIf(entry -> ((Registry)entry.getValue()).equals(toRm));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearRegistryNotDestroy() {
        this.registries.clear();
    }

    public static RegistryManager getInstance(ApplicationModel applicationModel) {
        return applicationModel.getBeanFactory().getBean(RegistryManager.class);
    }
}

