/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ExecutorUtil;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.ConnectionHandler;
import org.apache.dubbo.remoting.api.NettyEventLoopFactory;
import org.apache.dubbo.remoting.api.SslClientTlsHandler;
import org.apache.dubbo.remoting.api.WireProtocol;

public class Connection
extends AbstractReferenceCounted
implements ReferenceCounted {
    public static final AttributeKey<Connection> CONNECTION = AttributeKey.valueOf((String)"connection");
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static final Object CONNECTED_OBJECT = new Object();
    private final URL url;
    private final int connectTimeout;
    private final WireProtocol protocol;
    private final InetSocketAddress remote;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean init = new AtomicBoolean(false);
    private final Promise<Void> closePromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final AtomicReference<Channel> channel = new AtomicReference();
    private final Bootstrap bootstrap;
    private final ConnectionListener connectionListener = new ConnectionListener();
    private volatile Promise<Object> connectingPromise;

    public Connection(URL url) {
        url = ExecutorUtil.setThreadName(url, "DubboClientHandler");
        this.url = url = url.addParameterIfAbsent("threadpool", "cached");
        this.protocol = ExtensionLoader.getExtensionLoader(WireProtocol.class).getExtension(url.getProtocol());
        this.connectTimeout = url.getPositiveParameter("connect.timeout", 3000);
        this.remote = this.getConnectAddress();
        this.bootstrap = this.create();
    }

    public static Connection getConnectionFromChannel(Channel channel) {
        return (Connection)((Object)channel.attr(CONNECTION).get());
    }

    public Promise<Void> getClosePromise() {
        return this.closePromise;
    }

    private Bootstrap create() {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).remoteAddress((SocketAddress)this.getConnectAddress()).channel(NettyEventLoopFactory.socketChannelClass());
        final ConnectionHandler connectionHandler = new ConnectionHandler(this);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectTimeout);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                SslContext sslContext = null;
                if (Connection.this.getUrl().getParameter("ssl-enabled", false)) {
                    ch.pipeline().addLast("negotiation", (ChannelHandler)new SslClientTlsHandler(Connection.this.url));
                }
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{connectionHandler});
                Connection.this.protocol.configClientPipeline(Connection.this.url, p, sslContext);
            }
        });
        return bootstrap;
    }

    public ChannelFuture connect() {
        if (this.isClosed()) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s aborted to reconnect cause connection closed. ", new Object[]{this}));
            }
            return null;
        }
        this.connectingPromise = new DefaultPromise((EventExecutor)GlobalEventExecutor.INSTANCE);
        ChannelFuture promise = this.bootstrap.connect();
        promise.addListener((GenericFutureListener)this.connectionListener);
        return promise;
    }

    public Channel getChannel() {
        return this.channel.get();
    }

    public String toString() {
        return super.toString() + " (Ref=" + ReferenceCountUtil.refCnt((Object)((Object)this)) + ",local=" + (this.getChannel() == null ? null : this.getChannel().localAddress()) + ",remote=" + this.getRemote();
    }

    public void onGoaway(Channel channel) {
        if (this.channel.compareAndSet(channel, null) && logger.isDebugEnabled()) {
            logger.debug(String.format("%s goaway", new Object[]{this}));
        }
    }

    public void onConnected(Channel channel) {
        this.channel.set(channel);
        this.connectingPromise.setSuccess(CONNECTED_OBJECT);
        channel.attr(CONNECTION).set((Object)this);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("%s connected ", new Object[]{this}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        if (this.isClosed()) {
            return false;
        }
        Channel channel = this.getChannel();
        if (channel != null && channel.isActive()) {
            return true;
        }
        Connection connection = this;
        synchronized (connection) {
            if (this.init.compareAndSet(false, true)) {
                this.connect();
            }
        }
        this.connectingPromise.awaitUninterruptibly((long)this.connectTimeout, TimeUnit.MILLISECONDS);
        channel = this.getChannel();
        return channel != null && channel.isActive();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public ChannelFuture write(Object request) throws RemotingException {
        if (!this.isAvailable()) {
            throw new RemotingException(null, null, "Failed to send request " + request + ", cause: The channel to " + this.remote + " is closed!");
        }
        return this.getChannel().writeAndFlush(request);
    }

    public InetSocketAddress getRemote() {
        return this.remote;
    }

    protected void deallocate() {
        if (this.closed.compareAndSet(false, true)) {
            this.close();
        }
        this.closePromise.setSuccess(null);
    }

    public void close() {
        Channel current;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Connection:%s freed ", new Object[]{this}));
        }
        if ((current = this.channel.get()) != null) {
            current.close();
        }
        this.channel.set(null);
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    private InetSocketAddress getConnectAddress() {
        return new InetSocketAddress(NetUtils.filterLocalHost(this.getUrl().getHost()), this.getUrl().getPort());
    }

    public URL getUrl() {
        return this.url;
    }

    class ConnectionListener
    implements ChannelFutureListener {
        ConnectionListener() {
        }

        public void operationComplete(ChannelFuture future) {
            if (future.isSuccess()) {
                return;
            }
            Connection conn = Connection.this;
            if (conn.isClosed() || conn.refCnt() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("%s aborted to reconnect. %s", new Object[]{conn, future.cause().getMessage()}));
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s is reconnecting, attempt=%d cause=%s", new Object[]{conn, 0, future.cause().getMessage()}));
            }
            EventLoop loop = future.channel().eventLoop();
            loop.schedule(conn::connect, 1L, TimeUnit.SECONDS);
        }
    }
}

