/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.config.SslConfig;
import org.apache.dubbo.config.context.ConfigManager;

public class SslContexts {
    private static final Logger logger = LoggerFactory.getLogger(SslContexts.class);

    public static SslContext buildServerSslContext(URL url) {
        SslContextBuilder sslClientContextBuilder;
        ConfigManager globalConfigManager = url.getOrDefaultApplicationModel().getApplicationConfigManager();
        SslConfig sslConfig = globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        try {
            String password = sslConfig.getServerKeyPassword();
            sslClientContextBuilder = password != null ? SslContextBuilder.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream(), (String)password) : SslContextBuilder.forServer((InputStream)sslConfig.getServerKeyCertChainPathStream(), (InputStream)sslConfig.getServerPrivateKeyPathStream());
            if (sslConfig.getServerTrustCertCollectionPathStream() != null) {
                sslClientContextBuilder.trustManager(sslConfig.getServerTrustCertCollectionPathStream());
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find certificate file or the certificate is invalid.", e);
        }
        try {
            return sslClientContextBuilder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    public static SslContext buildClientSslContext(URL url) {
        ConfigManager globalConfigManager = url.getOrDefaultApplicationModel().getApplicationConfigManager();
        SslConfig sslConfig = globalConfigManager.getSsl().orElseThrow(() -> new IllegalStateException("Ssl enabled, but no ssl cert information provided!"));
        SslContextBuilder builder = SslContextBuilder.forClient();
        try {
            if (sslConfig.getClientTrustCertCollectionPathStream() != null) {
                builder.trustManager(sslConfig.getClientTrustCertCollectionPathStream());
            }
            InputStream clientCertChainFilePath = sslConfig.getClientKeyCertChainPathStream();
            InputStream clientPrivateKeyFilePath = sslConfig.getClientPrivateKeyPathStream();
            if (clientCertChainFilePath != null && clientPrivateKeyFilePath != null) {
                String password = sslConfig.getClientKeyPassword();
                if (password != null) {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath, password);
                } else {
                    builder.keyManager(clientCertChainFilePath, clientPrivateKeyFilePath);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find certificate file or find invalid certificate.", e);
        }
        try {
            return builder.sslProvider(SslContexts.findSslProvider()).build();
        }
        catch (SSLException e) {
            throw new IllegalStateException("Build SslSession failed.", e);
        }
    }

    private static SslProvider findSslProvider() {
        if (OpenSsl.isAvailable()) {
            logger.info("Using OPENSSL provider.");
            return SslProvider.OPENSSL;
        }
        if (SslContexts.checkJdkProvider()) {
            logger.info("Using JDK provider.");
            return SslProvider.JDK;
        }
        throw new IllegalStateException("Could not find any valid TLS provider, please check your dependency or deployment environment, usually netty-tcnative, Conscrypt, or Jetty NPN/ALPN is needed.");
    }

    private static boolean checkJdkProvider() {
        Provider[] jdkProviders = Security.getProviders("SSLContext.TLS");
        return jdkProviders != null && jdkProviders.length > 0;
    }
}

