/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.cluster.filter.FilterChainBuilder;
import org.apache.dubbo.rpc.model.ScopeModelUtil;

@Activate(order=0)
public class DefaultFilterChainBuilder
implements FilterChainBuilder {
    @Override
    public <T> Invoker<T> buildInvokerChain(Invoker<T> originalInvoker, String key, String group) {
        Invoker<T> last = originalInvoker;
        URL url = originalInvoker.getUrl();
        List<Filter> filters = ScopeModelUtil.getExtensionLoader(Filter.class, url.getScopeModel()).getActivateExtension(url, key, group);
        if (!filters.isEmpty()) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                Filter filter = filters.get(i);
                Invoker<T> next = last;
                last = new FilterChainBuilder.FilterChainNode<T, Invoker<T>, Filter>(originalInvoker, next, filter);
            }
        }
        return last;
    }

    @Override
    public <T> ClusterInvoker<T> buildClusterInvokerChain(ClusterInvoker<T> originalInvoker, String key, String group) {
        ClusterInvoker<T> last = originalInvoker;
        URL url = originalInvoker.getUrl();
        List<ClusterFilter> filters = ScopeModelUtil.getExtensionLoader(ClusterFilter.class, url.getScopeModel()).getActivateExtension(url, key, group);
        if (!filters.isEmpty()) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ClusterFilter filter = filters.get(i);
                ClusterInvoker<T> next = last;
                last = new FilterChainBuilder.ClusterFilterChainNode<T, ClusterInvoker<T>, ClusterFilter>(originalInvoker, next, filter);
            }
        }
        return last;
    }
}

