/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.filter.support;

import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.AsyncRpcResult;
import org.apache.dubbo.rpc.BaseFilter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.PenetrateAttachmentSelector;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcContextAttachment;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.TimeoutCountDown;
import org.apache.dubbo.rpc.cluster.filter.ClusterFilter;
import org.apache.dubbo.rpc.model.ApplicationModel;

@Activate(group={"consumer"}, order=-10000)
public class ConsumerContextFilter
implements ClusterFilter,
BaseFilter.Listener {
    private ApplicationModel applicationModel;

    public ConsumerContextFilter(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        ExtensionLoader<PenetrateAttachmentSelector> selectorExtensionLoader;
        Set<String> supportedSelectors;
        RpcContext.getServiceContext().setInvocation(invocation).setLocalAddress(NetUtils.getLocalHost(), 0);
        RpcContextAttachment context = RpcContext.getClientAttachment();
        ((RpcContext)context).setAttachment("remote.application", invoker.getUrl().getApplication());
        if (invocation instanceof RpcInvocation) {
            ((RpcInvocation)invocation).setInvoker(invoker);
        }
        if (CollectionUtils.isNotEmpty(supportedSelectors = (selectorExtensionLoader = this.applicationModel.getExtensionLoader(PenetrateAttachmentSelector.class)).getSupportedExtensions())) {
            for (String supportedSelector : supportedSelectors) {
                Map<String, Object> selected = selectorExtensionLoader.getExtension(supportedSelector).select();
                if (!CollectionUtils.isNotEmptyMap(selected)) continue;
                ((RpcInvocation)invocation).addObjectAttachmentsIfAbsent(selected);
            }
        } else {
            ((RpcInvocation)invocation).addObjectAttachmentsIfAbsent(RpcContext.getServerAttachment().getObjectAttachments());
        }
        Map<String, Object> contextAttachments = RpcContext.getClientAttachment().getObjectAttachments();
        if (CollectionUtils.isNotEmptyMap(contextAttachments)) {
            ((RpcInvocation)invocation).addObjectAttachments(contextAttachments);
        }
        try {
            TimeoutCountDown timeoutCountDown;
            Object countDown = ((RpcContext)context).getObjectAttachment("timeout-countdown");
            if (countDown != null && (timeoutCountDown = (TimeoutCountDown)countDown).isExpired()) {
                AsyncRpcResult asyncRpcResult = AsyncRpcResult.newDefaultAsyncResult(new RpcException(8, "No time left for making the following call: " + invocation.getServiceName() + "." + invocation.getMethodName() + ", terminate directly."), invocation);
                return asyncRpcResult;
            }
            RpcContext.removeServerContext();
            Result result = invoker.invoke(invocation);
            return result;
        }
        finally {
            RpcContext.removeServiceContext();
            RpcContext.removeClientAttachment();
        }
    }

    @Override
    public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
        RpcContext.getServerContext().setObjectAttachments((Map)appResponse.getObjectAttachments());
    }

    @Override
    public void onError(Throwable t, Invoker<?> invoker, Invocation invocation) {
    }
}

