/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.router.state;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.RoaringBitmap;

public class BitList<E>
implements List<E> {
    private final RoaringBitmap rootMap;
    private final List<E> unmodifiableList;

    public BitList(List<E> unmodifiableList, boolean empty) {
        this.unmodifiableList = unmodifiableList;
        this.rootMap = new RoaringBitmap();
        if (!empty) {
            this.rootMap.add(0L, (long)unmodifiableList.size());
        }
    }

    public BitList(List<E> unmodifiableList, RoaringBitmap rootMap) {
        this.unmodifiableList = unmodifiableList;
        this.rootMap = rootMap;
    }

    public BitList(List<E> unmodifiableList) {
        this(unmodifiableList, false);
    }

    public List<E> getUnmodifiableList() {
        return this.unmodifiableList;
    }

    public void addIndex(int index) {
        this.rootMap.add(index);
    }

    public BitList<E> intersect(List<E> b, List<E> totalList) {
        RoaringBitmap resultMap = this.rootMap.clone();
        resultMap.and(((BitList)b).rootMap);
        return new BitList<E>(totalList, resultMap);
    }

    @Override
    public int size() {
        return this.rootMap.getCardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.rootMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        int idx = this.unmodifiableList.indexOf(o);
        return idx >= 0 && this.rootMap.contains(idx);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int prev = -1;

            @Override
            public boolean hasNext() {
                return -1L != BitList.this.rootMap.nextValue(this.prev + 1);
            }

            @Override
            public E next() {
                this.prev = (int)BitList.this.rootMap.nextValue(this.prev + 1);
                return BitList.this.unmodifiableList.get(this.prev);
            }

            @Override
            public void remove() {
                BitList.this.rootMap.remove(this.prev);
            }
        };
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] obj = new Object[size];
        for (int i = 0; i < size; ++i) {
            obj[i] = this.unmodifiableList.get(this.rootMap.select(i));
        }
        return obj;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        Object[] arr = this.toArray();
        if (a.length < size) {
            return Arrays.copyOf(arr, size, a.getClass());
        }
        System.arraycopy(arr, 0, a, 0, size);
        if (a.length > size) {
            a[size] = null;
        }
        return null;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.unmodifiableList.indexOf(o);
        if (idx > -1) {
            this.rootMap.remove(idx);
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object o : c) {
            this.remove(o);
        }
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
        this.rootMap.clear();
    }

    @Override
    public E get(int index) {
        int real = this.rootMap.select(index);
        return this.unmodifiableList.get(real);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        this.rootMap.remove(index);
        return null;
    }

    @Override
    public int indexOf(Object o) {
        PeekableIntIterator intIterator = this.rootMap.getIntIterator();
        int st = 0;
        while (intIterator.hasNext()) {
            int idxInMap = intIterator.next();
            if (this.unmodifiableList.get(idxInMap).equals(o)) {
                return st;
            }
            ++st;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }
}

