/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class AbstractProtocol
implements Protocol,
ScopeModelAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final Map<String, Exporter<?>> exporterMap = new ConcurrentHashMap();
    protected final Map<String, ProtocolServer> serverMap = new ConcurrentHashMap<String, ProtocolServer>();
    protected final Set<Invoker<?>> invokers = new ConcurrentHashSet();
    protected FrameworkModel frameworkModel;

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    protected static String serviceKey(URL url) {
        int port = url.getParameter("bind.port", url.getPort());
        return AbstractProtocol.serviceKey(port, url.getPath(), url.getVersion(), url.getGroup());
    }

    protected static String serviceKey(int port, String serviceName, String serviceVersion, String serviceGroup) {
        return ProtocolUtils.serviceKey(port, serviceName, serviceVersion, serviceGroup);
    }

    @Override
    public List<ProtocolServer> getServers() {
        return Collections.unmodifiableList(new ArrayList<ProtocolServer>(this.serverMap.values()));
    }

    @Override
    public void destroy() {
        for (Invoker<?> invoker : this.invokers) {
            if (invoker == null) continue;
            this.invokers.remove(invoker);
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Destroy reference: " + invoker.getUrl());
                }
                invoker.destroy();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
        for (String key : new ArrayList<String>(this.exporterMap.keySet())) {
            Exporter<?> exporter = this.exporterMap.remove(key);
            if (exporter == null) continue;
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Unexport service: " + exporter.getInvoker().getUrl());
                }
                exporter.unexport();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
    }

    @Override
    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        return this.protocolBindingRefer(type, url);
    }

    @Deprecated
    protected abstract <T> Invoker<T> protocolBindingRefer(Class<T> var1, URL var2) throws RpcException;

    public Map<String, Exporter<?>> getExporterMap() {
        return this.exporterMap;
    }

    public Collection<Exporter<?>> getExporters() {
        return Collections.unmodifiableCollection(this.exporterMap.values());
    }
}

