/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.dubbo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.serialize.Cleanable;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec;
import org.apache.dubbo.remoting.Decodeable;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.support.RpcUtils;

public class DecodeableRpcResult
extends AppResponse
implements Codec,
Decodeable {
    private static final Logger log = LoggerFactory.getLogger(DecodeableRpcResult.class);
    private Channel channel;
    private byte serializationType;
    private InputStream inputStream;
    private Response response;
    private Invocation invocation;
    private volatile boolean hasDecoded;

    public DecodeableRpcResult(Channel channel, Response response, InputStream is, Invocation invocation, byte id) {
        Assert.notNull((Object)channel, "channel == null");
        Assert.notNull((Object)response, "response == null");
        Assert.notNull((Object)is, "inputStream == null");
        this.channel = channel;
        this.response = response;
        this.inputStream = is;
        this.invocation = invocation;
        this.serializationType = id;
    }

    @Override
    public void encode(Channel channel, OutputStream output, Object message) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object decode(Channel channel, InputStream input) throws IOException {
        if (log.isDebugEnabled()) {
            Thread thread = Thread.currentThread();
            log.debug("Decoding in thread -- [" + thread.getName() + "#" + thread.getId() + "]");
        }
        if (this.invocation.getServiceModel() != null) {
            Thread.currentThread().setContextClassLoader(this.invocation.getServiceModel().getClassLoader());
        }
        ObjectInput in = CodecSupport.getSerialization(channel.getUrl(), this.serializationType).deserialize(channel.getUrl(), input);
        byte flag = in.readByte();
        switch (flag) {
            case 2: {
                break;
            }
            case 1: {
                this.handleValue(in);
                break;
            }
            case 0: {
                this.handleException(in);
                break;
            }
            case 5: {
                this.handleAttachment(in);
                break;
            }
            case 4: {
                this.handleValue(in);
                this.handleAttachment(in);
                break;
            }
            case 3: {
                this.handleException(in);
                this.handleAttachment(in);
                break;
            }
            default: {
                throw new IOException("Unknown result flag, expect '0' '1' '2' '3' '4' '5', but received: " + flag);
            }
        }
        if (in instanceof Cleanable) {
            ((Cleanable)((Object)in)).cleanup();
        }
        return this;
    }

    @Override
    public void decode() throws Exception {
        if (!this.hasDecoded && this.channel != null && this.inputStream != null) {
            try {
                Object serializationTypeObj;
                if (this.invocation != null && ConfigurationUtils.getSystemConfiguration(this.channel.getUrl().getScopeModel()).getBoolean("serialization.security.check", true) && (serializationTypeObj = this.invocation.get("serialization_id")) != null && (Byte)serializationTypeObj != this.serializationType) {
                    throw new IOException("Unexpected serialization id:" + this.serializationType + " received from network, please check if the peer send the right id.");
                }
                this.decode(this.channel, this.inputStream);
            }
            catch (Throwable e) {
                if (log.isWarnEnabled()) {
                    log.warn("Decode rpc result failed: " + e.getMessage(), e);
                }
                this.response.setStatus((byte)90);
                this.response.setErrorMessage(StringUtils.toString(e));
            }
            finally {
                this.hasDecoded = true;
            }
        }
    }

    private void handleValue(ObjectInput in) throws IOException {
        try {
            Object[] returnTypes = this.invocation instanceof RpcInvocation ? ((RpcInvocation)this.invocation).getReturnTypes() : RpcUtils.getReturnTypes(this.invocation);
            Object value = null;
            value = ArrayUtils.isEmpty(returnTypes) ? in.readObject() : (returnTypes.length == 1 ? in.readObject((Class)returnTypes[0]) : in.readObject((Class)returnTypes[0], (Type)returnTypes[1]));
            this.setValue(value);
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void handleException(ObjectInput in) throws IOException {
        try {
            this.setException(in.readThrowable());
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void handleAttachment(ObjectInput in) throws IOException {
        try {
            this.addObjectAttachments(in.readAttachments());
        }
        catch (ClassNotFoundException e) {
            this.rethrow(e);
        }
    }

    private void rethrow(Exception e) throws IOException {
        throw new IOException(StringUtils.toString("Read response data failed.", e));
    }
}

