/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Message;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.threadpool.manager.ExecutorRepository;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.FrameworkServiceRepository;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.ServerStream;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;
import org.apache.dubbo.rpc.protocol.tri.UnaryServerStream;
import org.apache.dubbo.triple.TripleWrapper;

public abstract class AbstractServerStream
extends AbstractStream
implements Stream {
    private final ProviderModel providerModel;
    private List<MethodDescriptor> methodDescriptors;
    private Invoker<?> invoker;
    private List<HeaderFilter> headerFilters;

    protected AbstractServerStream(URL url) {
        this(url, AbstractServerStream.lookupProviderModel(url));
    }

    protected AbstractServerStream(URL url, ProviderModel providerModel) {
        this(url, AbstractServerStream.lookupExecutor(url, providerModel), providerModel);
    }

    protected AbstractServerStream(URL url, Executor executor, ProviderModel providerModel) {
        super(url, executor);
        this.providerModel = providerModel;
        this.serialize(this.getUrl().getParameter("serialization", "hessian2"));
        this.headerFilters = url.getOrDefaultApplicationModel().getExtensionLoader(HeaderFilter.class).getActivateExtension(url, "header.filter");
    }

    private static Executor lookupExecutor(URL url, ProviderModel providerModel) {
        ExecutorService executor = null;
        if (providerModel != null) {
            executor = (ExecutorService)providerModel.getServiceMetadata().getAttribute("threadpool");
        }
        ExecutorRepository executorRepository = url.getOrDefaultApplicationModel().getExtensionLoader(ExecutorRepository.class).getDefaultExtension();
        if (executor == null) {
            executor = executorRepository.getExecutor(url);
        }
        if (executor == null) {
            executor = executorRepository.createExecutorIfAbsent(url);
        }
        return executor;
    }

    public static AbstractServerStream unary(URL url) {
        return new UnaryServerStream(url);
    }

    public static AbstractServerStream stream(URL url) {
        return new ServerStream(url);
    }

    private static ProviderModel lookupProviderModel(URL url) {
        FrameworkServiceRepository repo = ScopeModelUtil.getFrameworkModel(url.getScopeModel()).getServiceRepository();
        ProviderModel model = repo.lookupExportedService(url.getServiceKey());
        if (model != null) {
            ClassLoadUtil.switchContextLoader(model.getClassLoader());
        }
        return model;
    }

    public List<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors;
    }

    public AbstractServerStream methods(List<MethodDescriptor> methods) {
        this.methodDescriptors = methods;
        return this;
    }

    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    public List<HeaderFilter> getHeaderFilters() {
        return this.headerFilters;
    }

    public ProviderModel getProviderModel() {
        return this.providerModel;
    }

    protected RpcInvocation buildInvocation(Metadata metadata) {
        RpcInvocation inv = new RpcInvocation(this.getUrl().getServiceModel(), this.getMethodName(), this.getServiceDescriptor().getServiceName(), this.getUrl().getProtocolServiceKey(), this.getMethodDescriptor().getParameterClasses(), new Object[0]);
        inv.setTargetServiceUniqueName(this.getUrl().getServiceKey());
        inv.setReturnTypes(this.getMethodDescriptor().getReturnTypes());
        Map<String, Object> attachments = this.parseMetadataToAttachmentMap(metadata);
        inv.setObjectAttachments(attachments);
        for (HeaderFilter headerFilter : this.getHeaderFilters()) {
            inv = headerFilter.invoke(this.getInvoker(), inv);
        }
        return inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] deserializeRequest(byte[] data) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            if (this.getProviderModel() != null) {
                ClassLoadUtil.switchContextLoader(this.getProviderModel().getClassLoader());
            }
            if (this.getMethodDescriptor() == null || this.getMethodDescriptor().isNeedWrap()) {
                TripleWrapper.TripleRequestWrapper wrapper = TripleUtil.unpack(data, TripleWrapper.TripleRequestWrapper.class);
                if (!this.getSerializeType().equals(TripleUtil.convertHessianFromWrapper(wrapper.getSerializeType()))) {
                    this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INVALID_ARGUMENT).withDescription("Received inconsistent serialization type from client, reject to deserialize! Expected:" + this.getSerializeType() + " Actual:" + TripleUtil.convertHessianFromWrapper(wrapper.getSerializeType())));
                    Object[] objectArray = null;
                    return objectArray;
                }
                if (this.getMethodDescriptor() == null) {
                    Object[] paramTypes = (String[])wrapper.getArgTypesList().toArray((Object[])new String[wrapper.getArgsCount()]);
                    for (MethodDescriptor descriptor : this.getMethodDescriptors()) {
                        if (!Arrays.equals(descriptor.getCompatibleParamSignatures(), paramTypes)) continue;
                        this.method(descriptor);
                        break;
                    }
                    if (this.getMethodDescriptor() == null) {
                        this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNIMPLEMENTED).withDescription("Method :" + this.getMethodName() + "[" + Arrays.toString(paramTypes) + "] not found of service:" + this.getServiceDescriptor().getServiceName()));
                        Iterator<MethodDescriptor> iterator = null;
                        return iterator;
                    }
                }
                Object[] objectArray = TripleUtil.unwrapReq(this.getUrl(), wrapper, this.getMultipleSerialization());
                return objectArray;
            }
            Object[] objectArray = new Object[]{TripleUtil.unpack(data, this.getMethodDescriptor().getParameterClasses()[0])};
            return objectArray;
        }
        finally {
            ClassLoadUtil.switchContextLoader(tccl);
        }
    }

    protected byte[] encodeResponse(Object value) {
        Object message = this.getMethodDescriptor().isNeedWrap() ? TripleUtil.wrapResp(this.getUrl(), this.getSerializeType(), value, this.getMethodDescriptor(), this.getMultipleSerialization()) : (Message)value;
        return TripleUtil.pack(message);
    }

    @Override
    public void execute(Runnable runnable) {
        try {
            super.execute(() -> {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    LOGGER.error("Exception processing triple message", t);
                    this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Exception in invoker chain :" + t.getMessage()).withCause(t));
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOGGER.error("Provider's thread pool is full", e);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.RESOURCE_EXHAUSTED).withDescription("Provider's thread pool is full"));
        }
        catch (Throwable t) {
            LOGGER.error("Provider submit request to thread pool error ", t);
            this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(t).withDescription("Provider's error"));
        }
    }

    public AbstractServerStream service(ServiceDescriptor sd) {
        this.setServiceDescriptor(sd);
        return this;
    }

    public AbstractServerStream invoker(Invoker<?> invoker) {
        this.invoker = invoker;
        return this;
    }
}

