/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.DebugInfo;
import com.google.rpc.Status;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.serialize.MultipleSerialization;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.threadlocal.NamedInternalThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;

public abstract class AbstractStream
implements Stream {
    protected static final String DUPLICATED_DATA = "Duplicated data";
    private static final List<Executor> CALLBACK_EXECUTORS = new ArrayList<Executor>(4);
    private final URL url;
    private final MultipleSerialization multipleSerialization;
    private final StreamObserver<Object> streamObserver;
    private final TransportObserver transportObserver;
    private final Executor executor;
    private ServiceDescriptor serviceDescriptor;
    private MethodDescriptor methodDescriptor;
    private String methodName;
    private Request request;
    private String serializeType;
    private StreamObserver<Object> streamSubscriber;
    private TransportObserver transportSubscriber;

    protected AbstractStream(URL url) {
        this(url, AbstractStream.allocateCallbackExecutor());
    }

    protected AbstractStream(URL url, Executor executor) {
        this.url = url;
        this.executor = executor;
        String value = url.getParameter("serialize.multiple", "default");
        this.multipleSerialization = url.getOrDefaultFrameworkModel().getExtensionLoader(MultipleSerialization.class).getExtension(value);
        this.streamObserver = this.createStreamObserver();
        this.transportObserver = this.createTransportObserver();
    }

    private static Executor allocateCallbackExecutor() {
        return CALLBACK_EXECUTORS.get(ThreadLocalRandom.current().nextInt(4));
    }

    public Request getRequest() {
        return this.request;
    }

    public AbstractStream request(Request request) {
        this.request = request;
        return this;
    }

    @Override
    public void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public AbstractStream methodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public AbstractStream method(MethodDescriptor md) {
        this.methodDescriptor = md;
        return this;
    }

    protected abstract StreamObserver<Object> createStreamObserver();

    protected abstract TransportObserver createTransportObserver();

    public String getSerializeType() {
        return this.serializeType;
    }

    public AbstractStream serialize(String serializeType) {
        if ("hessian4".equals(serializeType)) {
            serializeType = "hessian2";
        }
        this.serializeType = serializeType;
        return this;
    }

    public MultipleSerialization getMultipleSerialization() {
        return this.multipleSerialization;
    }

    public StreamObserver<Object> getStreamSubscriber() {
        return this.streamSubscriber;
    }

    public TransportObserver getTransportSubscriber() {
        return this.transportSubscriber;
    }

    public MethodDescriptor getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public void subscribe(StreamObserver<Object> observer) {
        this.streamSubscriber = observer;
    }

    @Override
    public void subscribe(TransportObserver observer) {
        this.transportSubscriber = observer;
    }

    @Override
    public StreamObserver<Object> asStreamObserver() {
        return this.streamObserver;
    }

    @Override
    public TransportObserver asTransportObserver() {
        return this.transportObserver;
    }

    protected void transportError(GrpcStatus status, Map<String, Object> attachments, boolean onlyTrailers) {
        if (!onlyTrailers) {
            DefaultMetadata metadata = new DefaultMetadata();
            this.getTransportSubscriber().onMetadata(metadata, false);
        }
        Metadata trailers = this.getTrailers(status);
        if (attachments != null) {
            this.convertAttachment(trailers, attachments);
        }
        this.getTransportSubscriber().onMetadata(trailers, true);
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("[Triple-Server-Error] status=" + status.code.code + " service=" + this.getServiceDescriptor().getServiceName() + " method=" + this.getMethodName() + " onlyTrailers=" + onlyTrailers, status.cause);
        }
    }

    protected void transportError(GrpcStatus status, Map<String, Object> attachments) {
        this.transportError(status, attachments, false);
    }

    protected void transportError(GrpcStatus status) {
        this.transportError(status, null);
    }

    protected void transportError(Throwable throwable) {
        GrpcStatus status = new GrpcStatus(GrpcStatus.Code.UNKNOWN, throwable, throwable.getMessage());
        this.transportError(status, null);
    }

    private String getGrpcMessage(GrpcStatus status) {
        if (StringUtils.isNotEmpty(status.description)) {
            return status.description;
        }
        if (status.cause != null) {
            return status.cause.getMessage();
        }
        return "unknown";
    }

    private Metadata getTrailers(GrpcStatus grpcStatus) {
        DefaultMetadata metadata = new DefaultMetadata();
        metadata.put(TripleHeaderEnum.MESSAGE_KEY.getHeader(), this.getGrpcMessage(grpcStatus));
        metadata.put(TripleHeaderEnum.STATUS_KEY.getHeader(), String.valueOf(grpcStatus.code.code));
        Status.Builder builder = Status.newBuilder().setCode(grpcStatus.code.code).setMessage(this.getGrpcMessage(grpcStatus));
        Throwable throwable = grpcStatus.cause;
        if (throwable == null) {
            Status status = builder.build();
            metadata.put(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader(), TripleUtil.encodeBase64ASCII(status.toByteArray()));
            return metadata;
        }
        DebugInfo debugInfo = DebugInfo.newBuilder().addAllStackEntries(ExceptionUtils.getStackFrameList(throwable, 10)).build();
        builder.addDetails(Any.pack((Message)debugInfo));
        Status status = builder.build();
        metadata.put(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader(), TripleUtil.encodeBase64ASCII(status.toByteArray()));
        return metadata;
    }

    protected Map<String, Object> parseMetadataToAttachmentMap(Metadata metadata) {
        LinkedHashMap<String, Object> attachments = new LinkedHashMap<String, Object>();
        for (Map.Entry header : metadata) {
            String key = ((CharSequence)header.getKey()).toString();
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key) || TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            if (key.endsWith("-bin") && key.length() > 4) {
                try {
                    attachments.put(key.substring(0, key.length() - 4), TripleUtil.decodeASCIIByte((CharSequence)header.getValue()));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse response attachment key=" + key, e);
                }
                continue;
            }
            attachments.put(key, ((CharSequence)header.getValue()).toString());
        }
        return attachments;
    }

    protected void convertAttachment(Metadata metadata, Map<String, Object> attachments) {
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            String key = entry.getKey().toLowerCase(Locale.ROOT);
            if (Http2Headers.PseudoHeaderName.isPseudoHeader((CharSequence)key) || TripleHeaderEnum.containsExcludeAttachments(key)) continue;
            Object v = entry.getValue();
            this.convertSingleAttachment(metadata, key, v);
        }
    }

    private void convertSingleAttachment(Metadata metadata, String key, Object v) {
        try {
            if (v instanceof String) {
                String str = (String)v;
                metadata.put(key, str);
            } else if (v instanceof byte[]) {
                String str = TripleUtil.encodeBase64ASCII((byte[])v);
                metadata.put(key + "-bin", str);
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Meet exception when convert single attachment key:" + key + " value=" + v, t);
        }
    }

    static {
        NamedInternalThreadFactory tripleTF = new NamedInternalThreadFactory("tri-callback", true);
        for (int i = 0; i < 4; ++i) {
            ThreadPoolExecutor tp = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.DAYS, new LinkedBlockingQueue<Runnable>(1024), tripleTF, new ThreadPoolExecutor.AbortPolicy());
            CALLBACK_EXECUTORS.add(tp);
        }
    }

    protected static abstract class UnaryTransportObserver
    extends AbstractTransportObserver
    implements TransportObserver {
        private byte[] data;

        protected UnaryTransportObserver() {
        }

        public byte[] getData() {
            return this.data;
        }

        protected abstract void onError(GrpcStatus var1);

        @Override
        public void onComplete() {
            GrpcStatus status = this.extractStatusFromMeta(this.getHeaders());
            if (GrpcStatus.Code.isOk(status.code.code)) {
                this.doOnComplete();
            } else {
                this.onError(status);
            }
        }

        protected abstract void doOnComplete();

        @Override
        public void onData(byte[] in, boolean endStream) {
            if (this.data == null) {
                this.data = in;
            } else {
                this.onError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription(AbstractStream.DUPLICATED_DATA));
            }
        }
    }

    protected static abstract class AbstractTransportObserver
    implements TransportObserver {
        private Metadata headers;
        private Metadata trailers;

        protected AbstractTransportObserver() {
        }

        public Metadata getHeaders() {
            return this.headers;
        }

        public Metadata getTrailers() {
            return this.trailers;
        }

        @Override
        public void onMetadata(Metadata metadata, boolean endStream) {
            if (this.headers == null) {
                this.headers = metadata;
            } else {
                this.trailers = metadata;
            }
        }

        protected GrpcStatus extractStatusFromMeta(Metadata metadata) {
            if (metadata.contains(TripleHeaderEnum.STATUS_KEY.getHeader())) {
                int code = Integer.parseInt(metadata.get(TripleHeaderEnum.STATUS_KEY.getHeader()).toString());
                if (!GrpcStatus.Code.isOk(code)) {
                    GrpcStatus status = GrpcStatus.fromCode(code);
                    if (metadata.contains(TripleHeaderEnum.MESSAGE_KEY.getHeader())) {
                        String raw = metadata.get(TripleHeaderEnum.MESSAGE_KEY.getHeader()).toString();
                        status = status.withDescription(GrpcStatus.fromMessage(raw));
                    }
                    return status;
                }
                return GrpcStatus.fromCode(GrpcStatus.Code.OK);
            }
            return GrpcStatus.fromCode(GrpcStatus.Code.OK);
        }
    }
}

