/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AsciiString;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.GrpcDataDecoder;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleClientInboundHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleHttp2ClientResponseHandler;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;

public class ClientTransportObserver
implements TransportObserver {
    private final AsciiString SCHEME;
    private final ChannelHandlerContext ctx;
    private final Http2StreamChannel streamChannel;
    private final ChannelPromise promise;
    private boolean headerSent = false;
    private boolean endStreamSent = false;

    public ClientTransportObserver(ChannelHandlerContext ctx, AbstractClientStream stream, ChannelPromise promise) {
        this.ctx = ctx;
        this.promise = promise;
        Boolean ssl = (Boolean)ctx.channel().attr(TripleConstant.SSL_ATTRIBUTE_KEY).get();
        this.SCHEME = ssl != null && ssl != false ? TripleConstant.HTTPS_SCHEME : TripleConstant.HTTP_SCHEME;
        Http2StreamChannelBootstrap streamChannelBootstrap = new Http2StreamChannelBootstrap(ctx.channel());
        this.streamChannel = (Http2StreamChannel)streamChannelBootstrap.open().syncUninterruptibly().getNow();
        TripleHttp2ClientResponseHandler responseHandler = new TripleHttp2ClientResponseHandler();
        this.streamChannel.pipeline().addLast(new ChannelHandler[]{responseHandler}).addLast(new ChannelHandler[]{new GrpcDataDecoder(Integer.MAX_VALUE)}).addLast(new ChannelHandler[]{new TripleClientInboundHandler()});
        this.streamChannel.attr(TripleUtil.CLIENT_STREAM_KEY).set((Object)stream);
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream) {
        if (!this.headerSent) {
            Http2Headers headers = new DefaultHttp2Headers(true).path(metadata.get(TripleHeaderEnum.PATH_KEY.getHeader())).authority(metadata.get(TripleHeaderEnum.AUTHORITY_KEY.getHeader())).scheme((CharSequence)this.SCHEME).method((CharSequence)HttpMethod.POST.asciiName());
            metadata.forEach(e -> {
                Http2Headers cfr_ignored_0 = (Http2Headers)headers.set(e.getKey(), e.getValue());
            });
            this.headerSent = true;
            this.streamChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers, endStream)).addListener(future -> {
                if (!future.isSuccess()) {
                    this.promise.tryFailure(future.cause());
                }
            });
        }
    }

    @Override
    public void onData(byte[] data, boolean endStream) {
        ByteBuf buf = this.ctx.alloc().buffer();
        buf.writeByte(0);
        buf.writeInt(data.length);
        buf.writeBytes(data);
        this.streamChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(buf, endStream)).addListener(future -> {
            if (!future.isSuccess()) {
                this.promise.tryFailure(future.cause());
            }
        });
    }

    @Override
    public void onComplete() {
        if (!this.endStreamSent) {
            this.endStreamSent = true;
            this.streamChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(true)).addListener(future -> {
                if (future.isSuccess()) {
                    this.promise.trySuccess();
                } else {
                    this.promise.tryFailure(future.cause());
                }
            });
        }
    }
}

