/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2Headers;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class ServerTransportObserver
implements TransportObserver {
    private final ChannelHandlerContext ctx;
    private final ChannelPromise promise;
    private boolean headerSent = false;

    public ServerTransportObserver(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.ctx = ctx;
        this.promise = promise;
    }

    @Override
    public void onMetadata(Metadata metadata, boolean endStream) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(true);
        metadata.forEach(e -> headers.set(e.getKey(), e.getValue()));
        if (!this.headerSent) {
            this.headerSent = true;
            headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
            headers.set((Object)TripleHeaderEnum.CONTENT_TYPE_KEY.getHeader(), (Object)"application/grpc+proto");
        }
        this.ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers, endStream)).addListener(future -> {
            if (!future.isSuccess()) {
                this.promise.tryFailure(future.cause());
            }
        });
    }

    @Override
    public void onData(byte[] data, boolean endStream) {
        ByteBuf buf = this.ctx.alloc().buffer();
        buf.writeByte(0);
        buf.writeInt(data.length);
        buf.writeBytes(data);
        this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(buf, false));
    }
}

