/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.BoolValue;
import com.google.protobuf.BytesValue;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Empty;
import com.google.protobuf.EnumValue;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SingleProtobufUtils {
    private static final ConcurrentHashMap<Class<?>, Message> instCache = new ConcurrentHashMap();
    private static final ExtensionRegistryLite globalRegistry = ExtensionRegistryLite.getEmptyRegistry();
    private static final ConcurrentMap<Class<?>, SingleMessageMarshaller<?>> marshallers = new ConcurrentHashMap();

    static boolean isSupported(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        return MessageLite.class.isAssignableFrom(clazz);
    }

    public static <T extends MessageLite> void marshaller(T defaultInstance) {
        marshallers.put(defaultInstance.getClass(), new SingleMessageMarshaller<T>(defaultInstance));
    }

    public static Message defaultInst(Class<?> clz) {
        Message defaultInst = instCache.get(clz);
        if (defaultInst != null) {
            return defaultInst;
        }
        try {
            defaultInst = (Message)clz.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Create default protobuf instance failed ", e);
        }
        instCache.put(clz, defaultInst);
        return defaultInst;
    }

    public static <T> Parser<T> getParser(Class<T> clz) {
        Message defaultInst = SingleProtobufUtils.defaultInst(clz);
        return defaultInst.getParserForType();
    }

    public static <T> T deserialize(InputStream in, Class<T> clz) throws IOException {
        if (!SingleProtobufUtils.isSupported(clz)) {
            throw new IllegalArgumentException("This serialization only support google protobuf messages, but the actual input type is :" + clz.getName());
        }
        try {
            return (T)SingleProtobufUtils.getMarshaller(clz).parse(in);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IOException(e);
        }
    }

    public static void serialize(Object obj, OutputStream os) throws IOException {
        MessageLite msg = (MessageLite)obj;
        msg.writeTo(os);
    }

    private static SingleMessageMarshaller<?> getMarshaller(Class<?> clz) {
        return marshallers.computeIfAbsent(clz, k -> new SingleMessageMarshaller<Class>((Class)k));
    }

    static {
        SingleProtobufUtils.marshaller(Empty.getDefaultInstance());
        SingleProtobufUtils.marshaller(BoolValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(Int32Value.getDefaultInstance());
        SingleProtobufUtils.marshaller(Int64Value.getDefaultInstance());
        SingleProtobufUtils.marshaller(FloatValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(DoubleValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(BytesValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(StringValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(EnumValue.getDefaultInstance());
        SingleProtobufUtils.marshaller(ListValue.getDefaultInstance());
    }

    public static final class SingleMessageMarshaller<T extends MessageLite> {
        private final Parser<T> parser;
        private final T defaultInstance;

        SingleMessageMarshaller(Class<T> clz) {
            this.defaultInstance = SingleProtobufUtils.defaultInst(clz);
            this.parser = this.defaultInstance.getParserForType();
        }

        SingleMessageMarshaller(T defaultInstance) {
            this.defaultInstance = defaultInstance;
            this.parser = defaultInstance.getParserForType();
        }

        public T parse(InputStream stream) throws InvalidProtocolBufferException {
            return (T)((MessageLite)this.parser.parseFrom(stream, globalRegistry));
        }
    }
}

