/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.api.Connection;
import org.apache.dubbo.remoting.api.ConnectionHandler;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ConsumerModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ClientTransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleConstant;

public class TripleClientHandler
extends ChannelDuplexHandler {
    private final FrameworkModel frameworkModel;

    public TripleClientHandler(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Request) {
            this.writeRequest(ctx, (Request)msg, promise);
        } else {
            super.write(ctx, msg, promise);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Http2SettingsFrame)) {
            if (msg instanceof Http2GoAwayFrame) {
                ConnectionHandler connectionHandler = (ConnectionHandler)ctx.pipeline().get(ConnectionHandler.class);
                connectionHandler.onGoAway(ctx.channel());
                ReferenceCountUtil.release((Object)msg);
            } else {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    private void writeRequest(ChannelHandlerContext ctx, Request req, ChannelPromise promise) {
        RpcInvocation inv = (RpcInvocation)req.getData();
        URL url = inv.getInvoker().getUrl();
        ConsumerModel consumerModel = inv.getServiceModel() != null ? (ConsumerModel)inv.getServiceModel() : (ConsumerModel)url.getServiceModel();
        MethodDescriptor methodDescriptor = this.getTriMethodDescriptor(consumerModel, inv);
        ClassLoadUtil.switchContextLoader(consumerModel.getClassLoader());
        AbstractClientStream stream = methodDescriptor.isUnary() ? AbstractClientStream.unary(url) : AbstractClientStream.stream(url);
        String ssl = url.getParameter("ssl-enabled");
        if (StringUtils.isNotEmpty(ssl)) {
            ctx.channel().attr(TripleConstant.SSL_ATTRIBUTE_KEY).set((Object)Boolean.parseBoolean(ssl));
        }
        stream.service(consumerModel).connection(Connection.getConnectionFromChannel(ctx.channel())).method(methodDescriptor).methodName(methodDescriptor.getMethodName()).request(req).serialize((String)inv.getObjectAttachment("serialization")).subscribe(new ClientTransportObserver(ctx, stream, promise));
        if (methodDescriptor.isUnary()) {
            stream.asStreamObserver().onNext(inv);
            stream.asStreamObserver().onCompleted();
        } else {
            AppResponse result;
            Response response = new Response(req.getId(), req.getVersion());
            if (methodDescriptor.getRpcType() == MethodDescriptor.RpcType.BIDIRECTIONAL_STREAM || methodDescriptor.getRpcType() == MethodDescriptor.RpcType.CLIENT_STREAM) {
                StreamObserver streamObserver = (StreamObserver)inv.getArguments()[0];
                stream.subscribe(streamObserver);
                result = new AppResponse(stream.asStreamObserver());
            } else {
                StreamObserver streamObserver = (StreamObserver)inv.getArguments()[1];
                stream.subscribe(streamObserver);
                result = new AppResponse();
                stream.asStreamObserver().onNext(inv.getArguments()[0]);
                stream.asStreamObserver().onCompleted();
            }
            response.setResult(result);
            DefaultFuture2.received(stream.getConnection(), response);
        }
    }

    private MethodDescriptor getTriMethodDescriptor(ConsumerModel consumerModel, RpcInvocation inv) {
        List<MethodDescriptor> methodDescriptors = consumerModel.getServiceModel().getMethods(inv.getMethodName());
        if (CollectionUtils.isEmpty(methodDescriptors)) {
            throw new IllegalStateException("methodDescriptors must not be null method=" + inv.getMethodName());
        }
        for (MethodDescriptor methodDescriptor : methodDescriptors) {
            if (!Arrays.equals(inv.getParameterTypes(), methodDescriptor.getRealParameterClasses())) continue;
            return methodDescriptor;
        }
        throw new IllegalStateException("methodDescriptors must not be null method=" + inv.getMethodName());
    }
}

