/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import com.google.protobuf.Any;
import com.google.rpc.DebugInfo;
import com.google.rpc.Status;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.remoting.exchange.support.DefaultFuture2;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.protocol.tri.AbstractClientStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.ExceptionUtils;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;
import org.apache.dubbo.rpc.protocol.tri.TripleUtil;

public class UnaryClientStream
extends AbstractClientStream
implements Stream {
    protected UnaryClientStream(URL url) {
        super(url);
    }

    @Override
    protected StreamObserver<Object> createStreamObserver() {
        return new AbstractClientStream.ClientStreamObserver();
    }

    @Override
    protected TransportObserver createTransportObserver() {
        return new UnaryClientTransportObserver();
    }

    private class UnaryClientTransportObserver
    extends AbstractStream.UnaryTransportObserver
    implements TransportObserver {
        private UnaryClientTransportObserver() {
        }

        @Override
        public void doOnComplete() {
            UnaryClientStream.this.execute(() -> {
                try {
                    AppResponse result;
                    if (!Void.TYPE.equals(UnaryClientStream.this.getMethodDescriptor().getReturnClass())) {
                        Object resp = UnaryClientStream.this.deserializeResponse(this.getData());
                        result = new AppResponse(resp);
                    } else {
                        result = new AppResponse();
                    }
                    Response response = new Response(UnaryClientStream.this.getRequest().getId(), "1.0.0");
                    result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(this.getTrailers()));
                    response.setResult(result);
                    DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
                }
                catch (Exception e) {
                    GrpcStatus status = GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withCause(e).withDescription("Failed to deserialize response");
                    this.onError(status);
                }
            });
        }

        @Override
        protected void onError(GrpcStatus status) {
            UnaryClientStream.this.execute(() -> {
                Response response = new Response(UnaryClientStream.this.getRequest().getId(), "1.0.0");
                response.setErrorMessage(status.description);
                AppResponse result = new AppResponse();
                Metadata trailers = this.getTrailers() == null ? this.getHeaders() : this.getTrailers();
                result.setException(this.getThrowable(trailers));
                result.setObjectAttachments(UnaryClientStream.this.parseMetadataToAttachmentMap(trailers));
                response.setResult(result);
                if (!result.hasException()) {
                    byte code = GrpcStatus.toDubboStatus(status.code);
                    response.setStatus(code);
                }
                DefaultFuture2.received(UnaryClientStream.this.getConnection(), response);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Throwable getThrowable(Metadata metadata) {
            if (null == metadata) {
                return null;
            }
            if (!metadata.contains(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader())) {
                return null;
            }
            CharSequence raw = metadata.get(TripleHeaderEnum.STATUS_DETAIL_KEY.getHeader());
            byte[] statusDetailBin = TripleUtil.decodeASCIIByte(raw);
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Status statusDetail = TripleUtil.unpack(statusDetailBin, Status.class);
                List<Any> detailList = statusDetail.getDetailsList();
                Map<Class<?>, Object> classObjectMap = TripleUtil.tranFromStatusDetails(detailList);
                DebugInfo debugInfo = (DebugInfo)classObjectMap.get(DebugInfo.class);
                if (debugInfo == null) {
                    RpcException rpcException = new RpcException(statusDetail.getCode(), statusDetail.getMessage());
                    return rpcException;
                }
                String msg = ExceptionUtils.getStackFrameString((List<String>)debugInfo.getStackEntriesList());
                RpcException rpcException = new RpcException(statusDetail.getCode(), msg);
                return rpcException;
            }
            finally {
                ClassLoadUtil.switchContextLoader(tccl);
            }
        }
    }
}

