/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.remoting.TimeoutException;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.protocol.tri.AbstractServerStream;
import org.apache.dubbo.rpc.protocol.tri.AbstractStream;
import org.apache.dubbo.rpc.protocol.tri.ClassLoadUtil;
import org.apache.dubbo.rpc.protocol.tri.DefaultMetadata;
import org.apache.dubbo.rpc.protocol.tri.GrpcStatus;
import org.apache.dubbo.rpc.protocol.tri.Metadata;
import org.apache.dubbo.rpc.protocol.tri.Stream;
import org.apache.dubbo.rpc.protocol.tri.TransportObserver;
import org.apache.dubbo.rpc.protocol.tri.TripleHeaderEnum;

public class UnaryServerStream
extends AbstractServerStream
implements Stream {
    protected UnaryServerStream(URL url) {
        super(url);
    }

    @Override
    protected StreamObserver<Object> createStreamObserver() {
        return null;
    }

    @Override
    protected TransportObserver createTransportObserver() {
        return new UnaryServerTransportObserver();
    }

    private class UnaryServerTransportObserver
    extends AbstractStream.UnaryTransportObserver
    implements TransportObserver {
        private UnaryServerTransportObserver() {
        }

        @Override
        protected void onError(GrpcStatus status) {
            UnaryServerStream.this.transportError(status);
        }

        @Override
        public void doOnComplete() {
            if (this.getData() != null) {
                UnaryServerStream.this.execute(this::invoke);
            } else {
                this.onError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Missing request data"));
            }
        }

        public void invoke() {
            RpcInvocation invocation;
            try {
                invocation = UnaryServerStream.this.buildInvocation(this.getHeaders());
                Object[] arguments = UnaryServerStream.this.deserializeRequest(this.getData());
                if (arguments == null) {
                    return;
                }
                invocation.setArguments(arguments);
            }
            catch (Throwable t2) {
                Stream.LOGGER.warn("Exception processing triple message", t2);
                UnaryServerStream.this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.INTERNAL).withDescription("Decode request failed:" + t2.getMessage()));
                return;
            }
            Result result = UnaryServerStream.this.getInvoker().invoke(invocation);
            CompletableFuture<Object> future = result.thenApply(Function.identity());
            BiConsumer<Object, Throwable> onComplete = (appResult, t) -> {
                if (t != null) {
                    if (t instanceof TimeoutException) {
                        UnaryServerStream.this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.DEADLINE_EXCEEDED).withCause((Throwable)t));
                    } else {
                        UnaryServerStream.this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNKNOWN).withCause((Throwable)t));
                    }
                    return;
                }
                AppResponse response = (AppResponse)appResult;
                try {
                    byte[] data;
                    if (response.hasException()) {
                        Throwable exception = response.getException();
                        if (exception instanceof RpcException) {
                            UnaryServerStream.this.transportError(GrpcStatus.rpcExceptionCodeToGrpc(((RpcException)exception).getCode()).withCause(exception), response.getObjectAttachments());
                            GrpcStatus status = GrpcStatus.rpcExceptionCodeToGrpc(((RpcException)exception).getCode()).withCause(exception);
                            UnaryServerStream.this.transportError(status, response.getObjectAttachments());
                        } else {
                            UnaryServerStream.this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNKNOWN).withCause(exception), response.getObjectAttachments());
                        }
                        return;
                    }
                    DefaultMetadata metadata = new DefaultMetadata();
                    metadata.put((CharSequence)HttpHeaderNames.CONTENT_TYPE, "application/grpc+proto");
                    UnaryServerStream.this.getTransportSubscriber().onMetadata(metadata, false);
                    ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                    try {
                        ClassLoadUtil.switchContextLoader(UnaryServerStream.this.getProviderModel().getServiceInterfaceClass().getClassLoader());
                        data = UnaryServerStream.this.encodeResponse(response.getValue());
                    }
                    finally {
                        ClassLoadUtil.switchContextLoader(tccl);
                    }
                    UnaryServerStream.this.getTransportSubscriber().onData(data, false);
                    Metadata trailers = new DefaultMetadata().put(TripleHeaderEnum.STATUS_KEY.getHeader(), Integer.toString(GrpcStatus.Code.OK.code));
                    Map<String, Object> attachments = response.getObjectAttachments();
                    if (attachments != null) {
                        UnaryServerStream.this.convertAttachment(trailers, attachments);
                    }
                    UnaryServerStream.this.getTransportSubscriber().onMetadata(trailers, true);
                }
                catch (Throwable e) {
                    Stream.LOGGER.warn("Exception processing triple message", e);
                    if (e instanceof RpcException) {
                        GrpcStatus status = GrpcStatus.rpcExceptionCodeToGrpc(((RpcException)e).getCode()).withCause(e);
                        UnaryServerStream.this.transportError(status, response.getObjectAttachments());
                    }
                    UnaryServerStream.this.transportError(GrpcStatus.fromCode(GrpcStatus.Code.UNKNOWN).withDescription("Exception occurred in provider's execution:" + e.getMessage()).withCause(e), response.getObjectAttachments());
                }
            };
            future.whenComplete(onComplete);
            RpcContext.removeContext();
        }
    }
}

