/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import grpc.health.v1.Health;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleServiceRepository;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.protocol.tri.PathResolver;
import org.apache.dubbo.rpc.protocol.tri.service.HealthStatusManager;
import org.apache.dubbo.rpc.protocol.tri.service.TriHealthImpl;

public class TriBuiltinService {
    private final ProxyFactory proxyFactory;
    private final PathResolver pathResolver;
    private final ModuleServiceRepository repository;
    private final Health healthService;
    private final HealthStatusManager healthStatusManager;
    private final AtomicBoolean init = new AtomicBoolean();

    public TriBuiltinService(FrameworkModel frameworkModel) {
        this.healthStatusManager = new HealthStatusManager(new TriHealthImpl());
        this.healthService = this.healthStatusManager.getHealthService();
        this.proxyFactory = frameworkModel.getExtensionLoader(ProxyFactory.class).getAdaptiveExtension();
        this.pathResolver = frameworkModel.getExtensionLoader(PathResolver.class).getDefaultExtension();
        List<ApplicationModel> applicationModels = frameworkModel.getApplicationModels();
        if (CollectionUtils.isEmpty(applicationModels)) {
            throw new IllegalStateException("Should have at least one applicationModel in frameworkModel. FrameworkModel:" + frameworkModel);
        }
        this.repository = applicationModels.get(0).getInternalModule().getServiceRepository();
        this.init();
    }

    public void init() {
        if (this.init.compareAndSet(false, true)) {
            ServiceDescriptor serviceDescriptor = this.repository.registerService(Health.class);
            ServiceMetadata serviceMetadata = new ServiceMetadata();
            serviceMetadata.setServiceType(Health.class);
            serviceMetadata.setTarget(this.healthService);
            serviceMetadata.setServiceInterfaceName(Health.class.getName());
            serviceMetadata.generateServiceKey();
            ProviderModel providerModel = new ProviderModel(Health.class.getName(), this.healthService, serviceDescriptor, null, serviceMetadata);
            this.repository.registerProvider(providerModel);
            int port = 0;
            ServiceConfigURL url = new ServiceConfigURL("tri", null, null, "0.0.0.0", port, Health.class.getName());
            url.setServiceModel(providerModel);
            url.setScopeModel(ApplicationModel.defaultModel().getInternalModule());
            Invoker<Health> invoker = this.proxyFactory.getInvoker(this.healthService, Health.class, url);
            this.pathResolver.add(url.getServiceKey(), invoker);
            this.pathResolver.add(url.getServiceInterface(), invoker);
            providerModel.setDestroyCaller(() -> {
                this.pathResolver.remove(url.getServiceKey());
                this.pathResolver.remove(url.getServiceInterface());
                return null;
            });
        }
    }

    public HealthStatusManager getHealthStatusManager() {
        return this.healthStatusManager;
    }
}

