/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import grpc.health.v1.Health;
import grpc.health.v1.HealthCheckRequest;
import grpc.health.v1.HealthCheckResponse;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.RpcException;

public class TriHealthImpl
implements Health {
    private static final Logger logger = Logger.getLogger(TriHealthImpl.class.getName());
    private final Map<String, HealthCheckResponse.ServingStatus> statusMap = new ConcurrentHashMap<String, HealthCheckResponse.ServingStatus>();
    private final Object watchLock = new Object();
    private boolean terminal;
    private final HashMap<String, IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean>> watchers = new HashMap();

    public TriHealthImpl() {
        this.statusMap.put("", HealthCheckResponse.ServingStatus.SERVING);
    }

    @Override
    public HealthCheckResponse check(HealthCheckRequest request) {
        HealthCheckResponse.ServingStatus status = this.statusMap.get(request.getService());
        if (status != null) {
            return HealthCheckResponse.newBuilder().setStatus(status).build();
        }
        throw new RpcException(11, "unknown service " + request.getService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void watch(HealthCheckRequest request, StreamObserver<HealthCheckResponse> responseObserver) {
        String service = request.getService();
        Object object = this.watchLock;
        synchronized (object) {
            HealthCheckResponse.ServingStatus status = this.statusMap.get(service);
            responseObserver.onNext(TriHealthImpl.getResponseForWatch(status));
            IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
            if (serviceWatchers == null) {
                serviceWatchers = new IdentityHashMap();
                this.watchers.put(service, serviceWatchers);
            }
            serviceWatchers.put(responseObserver, Boolean.TRUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStatus(String service, HealthCheckResponse.ServingStatus status) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.FINE, "Ignoring status {} for {}", new Object[]{status, service});
                return;
            }
            this.setStatusInternal(service, status);
        }
    }

    private void setStatusInternal(String service, HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse.ServingStatus prevStatus = this.statusMap.put(service, status);
        if (prevStatus != status) {
            this.notifyWatchers(service, status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStatus(String service) {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.FINE, "Ignoring status clearing for {}", new Object[]{service});
                return;
            }
            HealthCheckResponse.ServingStatus prevStatus = this.statusMap.remove(service);
            if (prevStatus != null) {
                this.notifyWatchers(service, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enterTerminalState() {
        Object object = this.watchLock;
        synchronized (object) {
            if (this.terminal) {
                logger.log(Level.WARNING, "Already terminating", new RuntimeException());
                return;
            }
            this.terminal = true;
            for (String service : this.statusMap.keySet()) {
                this.setStatusInternal(service, HealthCheckResponse.ServingStatus.NOT_SERVING);
            }
        }
    }

    private void notifyWatchers(String service, HealthCheckResponse.ServingStatus status) {
        HealthCheckResponse response = TriHealthImpl.getResponseForWatch(status);
        IdentityHashMap<StreamObserver<HealthCheckResponse>, Boolean> serviceWatchers = this.watchers.get(service);
        if (serviceWatchers != null) {
            for (StreamObserver<HealthCheckResponse> responseObserver : serviceWatchers.keySet()) {
                responseObserver.onNext(response);
            }
        }
    }

    private static HealthCheckResponse getResponseForWatch(HealthCheckResponse.ServingStatus recordedStatus) {
        return HealthCheckResponse.newBuilder().setStatus(recordedStatus == null ? HealthCheckResponse.ServingStatus.SERVICE_UNKNOWN : recordedStatus).build();
    }
}

