/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.threadpool;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.threadpool.MemoryLimitCalculator;

public class MemorySafeLinkedBlockingQueue<E>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 8032578371739960142L;
    public static int THE_256_MB = 0x10000000;
    private int maxFreeMemory;

    public MemorySafeLinkedBlockingQueue() {
        this(THE_256_MB);
    }

    public MemorySafeLinkedBlockingQueue(int maxFreeMemory) {
        super(Integer.MAX_VALUE);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLinkedBlockingQueue(Collection<? extends E> c, int maxFreeMemory) {
        super(c);
        this.maxFreeMemory = maxFreeMemory;
    }

    public void setMaxFreeMemory(int maxFreeMemory) {
        this.maxFreeMemory = maxFreeMemory;
    }

    public int getMaxFreeMemory() {
        return this.maxFreeMemory;
    }

    public boolean hasRemainedMemory() {
        return MemoryLimitCalculator.maxAvailable() > (long)this.maxFreeMemory;
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (this.hasRemainedMemory()) {
            super.put(e);
        }
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.hasRemainedMemory() && super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(E e) {
        return this.hasRemainedMemory() && super.offer(e);
    }
}

