/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DubboShutdownHook
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(DubboShutdownHook.class);
    private final ApplicationModel applicationModel;
    private final AtomicBoolean registered = new AtomicBoolean(false);
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private final boolean ignoreListenShutdownHook;

    public DubboShutdownHook(ApplicationModel applicationModel) {
        super("DubboShutdownHook");
        this.applicationModel = applicationModel;
        Assert.notNull((Object)this.applicationModel, "ApplicationModel is null");
        this.ignoreListenShutdownHook = Boolean.parseBoolean(ConfigurationUtils.getProperty(applicationModel, "dubbo.shutdownHook.listenIgnore"));
        if (this.ignoreListenShutdownHook) {
            logger.info("dubbo.shutdownHook.listenIgnore configured, will ignore add shutdown hook to jvm.");
        }
    }

    @Override
    public void run() {
        if (this.destroyed.compareAndSet(false, true) && !this.ignoreListenShutdownHook) {
            if (logger.isInfoEnabled()) {
                logger.info("Run shutdown hook now.");
            }
            this.doDestroy();
        }
    }

    private void doDestroy() {
        this.applicationModel.destroy();
    }

    public void register() {
        if (this.registered.compareAndSet(false, true) && !this.ignoreListenShutdownHook) {
            try {
                Runtime.getRuntime().addShutdownHook(this);
            }
            catch (IllegalStateException e) {
                logger.warn("register shutdown hook failed: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("register shutdown hook failed: " + e.getMessage(), e);
            }
        }
    }

    public void unregister() {
        if (this.registered.compareAndSet(true, false) && !this.ignoreListenShutdownHook) {
            if (this.isAlive()) {
                return;
            }
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException e) {
                logger.warn("unregister shutdown hook failed: " + e.getMessage());
            }
            catch (Exception e) {
                logger.warn("unregister shutdown hook failed: " + e.getMessage(), e);
            }
        }
    }

    public boolean getRegistered() {
        return this.registered.get();
    }
}

