/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.MD5Utils;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.configcenter.support.nacos.NacosConfigServiceWrapper;

public class NacosDynamicConfiguration
implements DynamicConfiguration {
    private static final String GET_CONFIG_KEYS_PATH = "/v1/cs/configs";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_TIMEOUT = 5000L;
    private Properties nacosProperties;
    private final NacosConfigServiceWrapper configService;
    private final Map<String, NacosConfigListener> watchListenerMap;
    private MD5Utils md5Utils = new MD5Utils();

    NacosDynamicConfiguration(URL url) {
        this.nacosProperties = this.buildNacosProperties(url);
        this.configService = this.buildConfigService(url);
        this.watchListenerMap = new ConcurrentHashMap<String, NacosConfigListener>();
    }

    private NacosConfigServiceWrapper buildConfigService(URL url) {
        ConfigService configService = null;
        try {
            configService = NacosFactory.createConfigService((Properties)this.nacosProperties);
        }
        catch (NacosException e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error(e.getErrMsg(), e);
            }
            throw new IllegalStateException(e);
        }
        return new NacosConfigServiceWrapper(configService);
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        NacosDynamicConfiguration.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(':').append(url.getPort());
        String backup = url.getParameter("backup");
        if (backup != null) {
            serverAddrBuilder.append(',').append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private static void setProperties(URL url, Properties properties) {
        Map<String, String> parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll(parameters);
        if (StringUtils.isNotEmpty(url.getUsername())) {
            properties.put("username", url.getUsername());
        }
        if (StringUtils.isNotEmpty(url.getPassword())) {
            properties.put("password", url.getPassword());
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        }
    }

    private static void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else {
            properties.setProperty(propertyName, defaultValue);
        }
    }

    private NacosConfigListener createTargetListener(String key, String group) {
        NacosConfigListener configListener = new NacosConfigListener();
        configListener.fillContext(key, group);
        return configListener;
    }

    @Override
    public void close() throws Exception {
        this.configService.shutdown();
    }

    @Override
    public void addListener(String key, String group, ConfigurationListener listener) {
        String listenerKey = this.buildListenerKey(key, group);
        NacosConfigListener nacosConfigListener = this.watchListenerMap.computeIfAbsent(listenerKey, k -> this.createTargetListener(key, group));
        nacosConfigListener.addListener(listener);
        try {
            this.configService.addListener(key, group, (Listener)nacosConfigListener);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
        }
    }

    @Override
    public void removeListener(String key, String group, ConfigurationListener listener) {
        String listenerKey = this.buildListenerKey(key, group);
        NacosConfigListener eventListener = this.watchListenerMap.get(listenerKey);
        if (eventListener != null) {
            eventListener.removeListener(listener);
        }
    }

    @Override
    public String getConfig(String key, String group, long timeout) throws IllegalStateException {
        try {
            long nacosTimeout;
            long l = nacosTimeout = timeout < 0L ? this.getDefaultTimeout() : timeout;
            if (StringUtils.isEmpty(group)) {
                group = "dubbo";
            }
            return this.configService.getConfig(key, group, nacosTimeout);
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public ConfigItem getConfigItem(String key, String group) {
        String content = this.getConfig(key, group);
        String casMd5 = "";
        if (StringUtils.isNotEmpty(content)) {
            casMd5 = this.md5Utils.getMd5(content);
        }
        return new ConfigItem(content, casMd5);
    }

    @Override
    public Object getInternalProperty(String key) {
        try {
            return this.configService.getConfig(key, "dubbo", this.getDefaultTimeout());
        }
        catch (NacosException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public boolean publishConfig(String key, String group, String content) {
        boolean published = false;
        try {
            published = this.configService.publishConfig(key, group, content);
        }
        catch (NacosException e) {
            this.logger.error(e.getErrMsg(), e);
        }
        return published;
    }

    @Override
    public boolean publishConfigCas(String key, String group, String content, Object ticket) {
        try {
            if (!(ticket instanceof String)) {
                throw new IllegalArgumentException("nacos publishConfigCas requires string type ticket");
            }
            return this.configService.publishConfigCas(key, group, content, (String)ticket);
        }
        catch (NacosException e) {
            this.logger.warn("nacos publishConfigCas failed.", e);
            return false;
        }
    }

    @Override
    public long getDefaultTimeout() {
        return 5000L;
    }

    @Override
    public boolean removeConfig(String key, String group) {
        boolean removed;
        block2: {
            removed = false;
            try {
                removed = this.configService.removeConfig(key, group);
            }
            catch (NacosException e) {
                if (!this.logger.isErrorEnabled()) break block2;
                this.logger.error(e.getMessage(), e);
            }
        }
        return removed;
    }

    private String getProperty(String name, String defaultValue) {
        return this.nacosProperties.getProperty(name, defaultValue);
    }

    protected String buildListenerKey(String key, String group) {
        return key + '-' + group;
    }

    public class NacosConfigListener
    extends AbstractSharedListener {
        private Set<ConfigurationListener> listeners = new CopyOnWriteArraySet<ConfigurationListener>();
        private Map<String, String> cacheData = new ConcurrentHashMap<String, String>();

        public Executor getExecutor() {
            return null;
        }

        public void innerReceive(String dataId, String group, String configInfo) {
            String oldValue = this.cacheData.get(dataId);
            ConfigChangedEvent event = new ConfigChangedEvent(dataId, group, configInfo, this.getChangeType(configInfo, oldValue));
            if (configInfo == null) {
                this.cacheData.remove(dataId);
            } else {
                this.cacheData.put(dataId, configInfo);
            }
            this.listeners.forEach(listener -> listener.process(event));
        }

        void addListener(ConfigurationListener configurationListener) {
            this.listeners.add(configurationListener);
        }

        void removeListener(ConfigurationListener configurationListener) {
            this.listeners.remove(configurationListener);
        }

        private ConfigChangeType getChangeType(String configInfo, String oldValue) {
            if (StringUtils.isBlank(configInfo)) {
                return ConfigChangeType.DELETED;
            }
            if (StringUtils.isBlank(oldValue)) {
                return ConfigChangeType.ADDED;
            }
            return ConfigChangeType.MODIFIED;
        }
    }
}

