/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.configcenter.support.zookeeper;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigItem;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.TreePathDynamicConfiguration;
import org.apache.dubbo.common.threadpool.support.AbortPolicyWithReport;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.configcenter.support.zookeeper.CacheListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.zookeeper.data.Stat;

public class ZookeeperDynamicConfiguration
extends TreePathDynamicConfiguration {
    private Executor executor;
    private ZookeeperClient zkClient;
    private CacheListener cacheListener;
    private static final int DEFAULT_ZK_EXECUTOR_THREADS_NUM = 1;
    private static final int DEFAULT_QUEUE = 10000;
    private static final Long THREAD_KEEP_ALIVE_TIME = 0L;

    ZookeeperDynamicConfiguration(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        this.cacheListener = new CacheListener(this.rootPath);
        String threadName = this.getClass().getSimpleName();
        this.executor = new ThreadPoolExecutor(1, 1, THREAD_KEEP_ALIVE_TIME, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), new NamedThreadFactory(threadName, true), new AbortPolicyWithReport(threadName, url));
        this.zkClient = zookeeperTransporter.connect(url);
        boolean isConnected = this.zkClient.isConnected();
        if (!isConnected) {
            throw new IllegalStateException("Failed to connect with zookeeper, pls check if url " + url + " is correct.");
        }
    }

    @Override
    public String getInternalProperty(String key) {
        return this.zkClient.getContent(this.buildPathKey("", key));
    }

    @Override
    protected void doClose() throws Exception {
        this.zkClient = null;
    }

    @Override
    protected boolean doPublishConfig(String pathKey, String content) throws Exception {
        this.zkClient.create(pathKey, content, false);
        return true;
    }

    @Override
    public boolean publishConfigCas(String key, String group, String content, Object ticket) {
        try {
            if (ticket != null && !(ticket instanceof Stat)) {
                throw new IllegalArgumentException("zookeeper publishConfigCas requires stat type ticket");
            }
            String pathKey = this.buildPathKey(group, key);
            this.zkClient.createOrUpdate(pathKey, content, false, ticket == null ? 0 : ((Stat)ticket).getVersion());
            return true;
        }
        catch (Exception e) {
            this.logger.warn("zookeeper publishConfigCas failed.", e);
            return false;
        }
    }

    @Override
    protected String doGetConfig(String pathKey) throws Exception {
        return this.zkClient.getContent(pathKey);
    }

    @Override
    public ConfigItem getConfigItem(String key, String group) {
        String pathKey = this.buildPathKey(group, key);
        return this.zkClient.getConfigItem(pathKey);
    }

    @Override
    protected boolean doRemoveConfig(String pathKey) throws Exception {
        this.zkClient.delete(pathKey);
        return true;
    }

    @Override
    protected Collection<String> doGetConfigKeys(String groupPath) {
        return this.zkClient.getChildren(groupPath);
    }

    @Override
    protected void doAddListener(String pathKey, ConfigurationListener listener) {
        this.cacheListener.addListener(pathKey, listener);
        this.zkClient.addDataListener(pathKey, this.cacheListener, this.executor);
    }

    @Override
    protected void doRemoveListener(String pathKey, ConfigurationListener listener) {
        this.cacheListener.removeListener(pathKey, listener);
        Set<ConfigurationListener> configurationListeners = this.cacheListener.getConfigurationListeners(pathKey);
        if (CollectionUtils.isEmpty(configurationListeners)) {
            this.zkClient.removeDataListener(pathKey, this.cacheListener);
        }
    }
}

