/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.server.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.qos.command.CommandContext;
import org.apache.dubbo.qos.command.CommandExecutor;
import org.apache.dubbo.qos.command.DefaultCommandExecutor;
import org.apache.dubbo.qos.command.NoSuchCommandException;
import org.apache.dubbo.qos.command.decoder.TelnetCommandDecoder;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class TelnetProcessHandler
extends SimpleChannelInboundHandler<String> {
    private static final Logger log = LoggerFactory.getLogger(TelnetProcessHandler.class);
    private final CommandExecutor commandExecutor;

    public TelnetProcessHandler(FrameworkModel frameworkModel) {
        this.commandExecutor = new DefaultCommandExecutor(frameworkModel);
    }

    protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        if (StringUtils.isBlank(msg)) {
            ctx.writeAndFlush((Object)"dubbo>");
        } else {
            CommandContext commandContext = TelnetCommandDecoder.decode(msg);
            commandContext.setRemote(ctx.channel());
            try {
                String result = this.commandExecutor.execute(commandContext);
                if (StringUtils.isEquals("close!", result)) {
                    ctx.writeAndFlush((Object)this.getByeLabel()).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                } else {
                    ctx.writeAndFlush((Object)(result + "\r\n" + "dubbo>"));
                }
            }
            catch (NoSuchCommandException ex) {
                ctx.writeAndFlush((Object)(msg + " :no such command"));
                ctx.writeAndFlush((Object)"\r\ndubbo>");
                log.error("can not found command " + commandContext, ex);
            }
            catch (Exception ex) {
                ctx.writeAndFlush((Object)(msg + " :fail to execute commandContext by " + ex.getMessage()));
                ctx.writeAndFlush((Object)"\r\ndubbo>");
                log.error("execute commandContext got exception " + commandContext, ex);
            }
        }
    }

    private String getByeLabel() {
        return "BYE!\n";
    }
}

