/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.List;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;

public interface ServiceDiscovery
extends RegistryService,
Prioritized {
    public void register() throws RuntimeException;

    public void update() throws RuntimeException;

    public void unregister() throws RuntimeException;

    public Set<String> getServices();

    public List<ServiceInstance> getInstances(String var1) throws NullPointerException;

    default public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
    }

    default public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
    }

    default public ServiceInstancesChangedListener createListener(Set<String> serviceNames) {
        return new ServiceInstancesChangedListener(serviceNames, this);
    }

    public ServiceInstance getLocalInstance();

    public MetadataInfo getLocalMetadata();

    public MetadataInfo getRemoteMetadata(String var1);

    public MetadataInfo getRemoteMetadata(String var1, List<ServiceInstance> var2);

    public void destroy() throws Exception;

    public boolean isDestroy();

    default public URL getUrl() {
        return null;
    }

    default public long getDelay() {
        return this.getUrl().getParameter("delay-notification", 5000);
    }

    public String toString();
}

