/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.ThreadlessExecutor;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.InvokeMode;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;
import org.apache.dubbo.rpc.protocol.dubbo.FutureAdapter;

public class AsyncRpcResult
implements Result {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRpcResult.class);
    private RpcContext.RestoreContext storedContext;
    private Executor executor;
    private Invocation invocation;
    private final boolean async;
    private CompletableFuture<AppResponse> responseFuture;
    private static final boolean setFutureWhenSync = Boolean.parseBoolean(System.getProperty("future.sync.set", "true"));

    public AsyncRpcResult(CompletableFuture<AppResponse> future, Invocation invocation) {
        this.responseFuture = future;
        this.invocation = invocation;
        RpcInvocation rpcInvocation = (RpcInvocation)invocation;
        if (!(rpcInvocation.get("PROVIDER_ASYNC") == null && InvokeMode.SYNC == rpcInvocation.getInvokeMode() || future.isDone())) {
            this.async = true;
            this.storedContext = RpcContext.clearAndStoreContext();
        } else {
            this.async = false;
        }
    }

    @Override
    public Object getValue() {
        return this.getAppResponse().getValue();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (this.responseFuture.isDone()) {
                this.responseFuture.get().setValue(value);
            } else {
                AppResponse appResponse = new AppResponse(this.invocation);
                appResponse.setValue(value);
                this.responseFuture.complete(appResponse);
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to fetch the underlying result from AsyncRpcResult.");
            throw new RpcException(e);
        }
    }

    @Override
    public Throwable getException() {
        return this.getAppResponse().getException();
    }

    @Override
    public void setException(Throwable t) {
        try {
            if (this.responseFuture.isDone()) {
                this.responseFuture.get().setException(t);
            } else {
                AppResponse appResponse = new AppResponse(this.invocation);
                appResponse.setException(t);
                this.responseFuture.complete(appResponse);
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to fetch the underlying result from AsyncRpcResult.");
            throw new RpcException(e);
        }
    }

    @Override
    public boolean hasException() {
        return this.getAppResponse().hasException();
    }

    public CompletableFuture<AppResponse> getResponseFuture() {
        return this.responseFuture;
    }

    public void setResponseFuture(CompletableFuture<AppResponse> responseFuture) {
        this.responseFuture = responseFuture;
    }

    public Result getAppResponse() {
        try {
            if (this.responseFuture.isDone()) {
                return this.responseFuture.get();
            }
        }
        catch (Exception e) {
            logger.error("Got exception when trying to fetch the underlying result from AsyncRpcResult.");
            throw new RpcException(e);
        }
        return AsyncRpcResult.createDefaultValue(this.invocation);
    }

    @Override
    public Result get() throws InterruptedException, ExecutionException {
        if (this.executor != null && this.executor instanceof ThreadlessExecutor) {
            ThreadlessExecutor threadlessExecutor = (ThreadlessExecutor)this.executor;
            threadlessExecutor.waitAndDrain();
        }
        return this.responseFuture.get();
    }

    @Override
    public Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.executor != null && this.executor instanceof ThreadlessExecutor) {
            ThreadlessExecutor threadlessExecutor = (ThreadlessExecutor)this.executor;
            threadlessExecutor.waitAndDrain();
        }
        return this.responseFuture.get(timeout, unit);
    }

    @Override
    public Object recreate() throws Throwable {
        RpcInvocation rpcInvocation = (RpcInvocation)this.invocation;
        if (InvokeMode.FUTURE == rpcInvocation.getInvokeMode()) {
            return RpcContext.getClientAttachment().getFuture();
        }
        if (InvokeMode.ASYNC == rpcInvocation.getInvokeMode()) {
            return AsyncRpcResult.createDefaultValue(this.invocation).recreate();
        }
        return this.getAppResponse().recreate();
    }

    @Override
    public Result whenCompleteWithContext(BiConsumer<Result, Throwable> fn) {
        this.responseFuture = this.responseFuture.whenComplete((v, t) -> {
            if (this.async) {
                RpcContext.restoreContext(this.storedContext);
            }
            fn.accept((Result)v, (Throwable)t);
        });
        if (setFutureWhenSync || ((RpcInvocation)this.invocation).getInvokeMode() != InvokeMode.SYNC) {
            RpcContext.getServiceContext().setFuture(new FutureAdapter(this.responseFuture));
        }
        return this;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<Result, ? extends U> fn) {
        return this.responseFuture.thenApply(fn);
    }

    @Override
    @Deprecated
    public Map<String, String> getAttachments() {
        return this.getAppResponse().getAttachments();
    }

    @Override
    public Map<String, Object> getObjectAttachments() {
        return this.getAppResponse().getObjectAttachments();
    }

    @Override
    public void setAttachments(Map<String, String> map) {
        this.getAppResponse().setAttachments(map);
    }

    @Override
    public void setObjectAttachments(Map<String, Object> map) {
        this.getAppResponse().setObjectAttachments(map);
    }

    @Override
    @Deprecated
    public void addAttachments(Map<String, String> map) {
        this.getAppResponse().addAttachments(map);
    }

    @Override
    public void addObjectAttachments(Map<String, Object> map) {
        this.getAppResponse().addObjectAttachments(map);
    }

    @Override
    public String getAttachment(String key) {
        return this.getAppResponse().getAttachment(key);
    }

    @Override
    public Object getObjectAttachment(String key) {
        return this.getAppResponse().getObjectAttachment(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        return this.getAppResponse().getAttachment(key, defaultValue);
    }

    @Override
    public Object getObjectAttachment(String key, Object defaultValue) {
        return this.getAppResponse().getObjectAttachment(key, defaultValue);
    }

    @Override
    public void setAttachment(String key, String value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    public void setAttachment(String key, Object value) {
        this.setObjectAttachment(key, value);
    }

    @Override
    public void setObjectAttachment(String key, Object value) {
        this.getAppResponse().setAttachment(key, value);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public static AsyncRpcResult newDefaultAsyncResult(AppResponse appResponse, Invocation invocation) {
        return new AsyncRpcResult(CompletableFuture.completedFuture(appResponse), invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(null, null, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Object value, Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(value, null, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Throwable t, Invocation invocation) {
        return AsyncRpcResult.newDefaultAsyncResult(null, t, invocation);
    }

    public static AsyncRpcResult newDefaultAsyncResult(Object value, Throwable t, Invocation invocation) {
        CompletableFuture<AppResponse> future = new CompletableFuture<AppResponse>();
        AppResponse result = new AppResponse(invocation);
        if (t != null) {
            result.setException(t);
        } else {
            result.setValue(value);
        }
        future.complete(result);
        return new AsyncRpcResult(future, invocation);
    }

    private static Result createDefaultValue(Invocation invocation) {
        ConsumerMethodModel method = (ConsumerMethodModel)invocation.get("methodModel");
        return method != null ? new AppResponse(ReflectUtils.defaultReturn(method.getReturnClass())) : new AppResponse();
    }
}

