/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.MemberUtils;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;

public interface MethodUtils {
    public static boolean isSetter(Method method) {
        return method.getName().startsWith("set") && !"set".equals(method.getName()) && Modifier.isPublic(method.getModifiers()) && method.getParameterCount() == 1 && ClassUtils.isPrimitive(method.getParameterTypes()[0]);
    }

    public static boolean isGetter(Method method) {
        String name = method.getName();
        return (name.startsWith("get") || name.startsWith("is")) && !"get".equals(name) && !"is".equals(name) && !"getClass".equals(name) && !"getObject".equals(name) && Modifier.isPublic(method.getModifiers()) && method.getParameterTypes().length == 0 && ClassUtils.isPrimitive(method.getReturnType());
    }

    public static boolean isMetaMethod(Method method) {
        String name = method.getName();
        if (!name.startsWith("get") && !name.startsWith("is")) {
            return false;
        }
        if ("get".equals(name)) {
            return false;
        }
        if ("getClass".equals(name)) {
            return false;
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        return ClassUtils.isPrimitive(method.getReturnType());
    }

    public static boolean isDeprecated(Method method) {
        return method.getAnnotation(Deprecated.class) != null;
    }

    public static Predicate<Method> excludedDeclaredClass(Class<?> declaredClass) {
        return method -> !Objects.equals(declaredClass, method.getDeclaringClass());
    }

    public static List<Method> getMethods(Class<?> declaringClass, boolean includeInheritedTypes, boolean publicOnly, Predicate<Method> ... methodsToFilter) {
        if (declaringClass == null || declaringClass.isPrimitive()) {
            return Collections.emptyList();
        }
        LinkedList declaredClasses = new LinkedList();
        declaredClasses.add(declaringClass);
        if (includeInheritedTypes) {
            declaredClasses.addAll(ClassUtils.getAllInheritedTypes(declaringClass, new Predicate[0]));
        }
        LinkedList<Method> allMethods = new LinkedList<Method>();
        for (Class clazz : declaredClasses) {
            Method[] methods;
            for (Method method : methods = publicOnly ? clazz.getMethods() : clazz.getDeclaredMethods()) {
                allMethods.add(method);
            }
        }
        return Collections.unmodifiableList(Streams.filterAll(allMethods, methodsToFilter));
    }

    public static List<Method> getDeclaredMethods(Class<?> declaringClass, Predicate<Method> ... methodsToFilter) {
        return MethodUtils.getMethods(declaringClass, false, false, methodsToFilter);
    }

    public static List<Method> getMethods(Class<?> declaringClass, Predicate<Method> ... methodsToFilter) {
        return MethodUtils.getMethods(declaringClass, false, true, methodsToFilter);
    }

    public static List<Method> getAllDeclaredMethods(Class<?> declaringClass, Predicate<Method> ... methodsToFilter) {
        return MethodUtils.getMethods(declaringClass, true, false, methodsToFilter);
    }

    public static List<Method> getAllMethods(Class<?> declaringClass, Predicate<Method> ... methodsToFilter) {
        return MethodUtils.getMethods(declaringClass, true, true, methodsToFilter);
    }

    public static Method findMethod(Class type, String methodName) {
        return MethodUtils.findMethod(type, methodName, ReflectUtils.EMPTY_CLASS_ARRAY);
    }

    public static Method findMethod(Class type, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            if (type != null && StringUtils.isNotEmpty(methodName)) {
                method = type.getDeclaredMethod(methodName, parameterTypes);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return method;
    }

    public static <T> T invokeMethod(Object object, String methodName, Object ... methodParameters) {
        Class<?> type = object.getClass();
        Class[] parameterTypes = ReflectUtils.resolveTypes(methodParameters);
        Method method = MethodUtils.findMethod(type, methodName, parameterTypes);
        Object value = null;
        try {
            ReflectUtils.makeAccessible(method);
            value = method.invoke(object, methodParameters);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return (T)value;
    }

    public static boolean overrides(Method overrider, Method overridden) {
        if (overrider == null || overridden == null) {
            return false;
        }
        if (Objects.equals(overrider, overridden)) {
            return false;
        }
        if (MemberUtils.isStatic(overrider) || MemberUtils.isStatic(overridden)) {
            return false;
        }
        if (MemberUtils.isPrivate(overrider) || MemberUtils.isPrivate(overridden)) {
            return false;
        }
        if (!overridden.getDeclaringClass().isAssignableFrom(overrider.getDeclaringClass())) {
            return false;
        }
        if (overrider.isDefault()) {
            return false;
        }
        if (!Objects.equals(overrider.getName(), overridden.getName())) {
            return false;
        }
        if (!Objects.equals(overrider.getParameterCount(), overridden.getParameterCount())) {
            return false;
        }
        for (int i = 0; i < overrider.getParameterCount(); ++i) {
            if (Objects.equals(overridden.getParameterTypes()[i], overrider.getParameterTypes()[i])) continue;
            return false;
        }
        return overridden.getReturnType().isAssignableFrom(overrider.getReturnType());
    }

    public static Method findNearestOverriddenMethod(Method overrider) {
        Class<?> inheritedType;
        Class<?> declaringClass = overrider.getDeclaringClass();
        Method overriddenMethod = null;
        Iterator<Class<?>> iterator = ClassUtils.getAllInheritedTypes(declaringClass, new Predicate[0]).iterator();
        while (iterator.hasNext() && (overriddenMethod = MethodUtils.findOverriddenMethod(overrider, inheritedType = iterator.next())) == null) {
        }
        return overriddenMethod;
    }

    public static Method findOverriddenMethod(Method overrider, Class<?> declaringClass) {
        List<Method> matchedMethods = MethodUtils.getAllMethods(declaringClass, method -> MethodUtils.overrides(overrider, method));
        return matchedMethods.isEmpty() ? null : matchedMethods.get(0);
    }
}

