/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.extension.support;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.utils.ArrayUtils;

public class ActivateComparator
implements Comparator<Class> {
    public static final Comparator<Class> COMPARATOR = new ActivateComparator();

    @Override
    public int compare(Class o1, Class o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        Class<?> inf = this.findSpi(o1);
        ActivateInfo a1 = this.parseActivate(o1);
        ActivateInfo a2 = this.parseActivate(o2);
        if ((a1.applicableToCompare() || a2.applicableToCompare()) && inf != null) {
            ExtensionLoader<?> extensionLoader = ExtensionLoader.getExtensionLoader(inf);
            if (a1.applicableToCompare()) {
                String n2 = extensionLoader.getExtensionName(o2);
                if (a1.isLess(n2)) {
                    return -1;
                }
                if (a1.isMore(n2)) {
                    return 1;
                }
            }
            if (a2.applicableToCompare()) {
                String n1 = extensionLoader.getExtensionName(o1);
                if (a2.isLess(n1)) {
                    return 1;
                }
                if (a2.isMore(n1)) {
                    return -1;
                }
            }
        }
        return a1.order > a2.order ? 1 : -1;
    }

    private Class<?> findSpi(Class clazz) {
        if (clazz.getInterfaces().length == 0) {
            return null;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (intf.isAnnotationPresent(SPI.class)) {
                return intf;
            }
            Class<?> result = this.findSpi(intf);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private ActivateInfo parseActivate(Class<?> clazz) {
        ActivateInfo info = new ActivateInfo();
        if (clazz.isAnnotationPresent(Activate.class)) {
            Activate activate = clazz.getAnnotation(Activate.class);
            ActivateInfo.access$502(info, activate.before());
            ActivateInfo.access$602(info, activate.after());
            info.order = activate.order();
        } else {
            com.alibaba.dubbo.common.extension.Activate activate = clazz.getAnnotation(com.alibaba.dubbo.common.extension.Activate.class);
            ActivateInfo.access$502(info, activate.before());
            ActivateInfo.access$602(info, activate.after());
            info.order = activate.order();
        }
        return info;
    }

    private static class ActivateInfo {
        private String[] before;
        private String[] after;
        private int order;

        private ActivateInfo() {
        }

        private boolean applicableToCompare() {
            return ArrayUtils.isNotEmpty(this.before) || ArrayUtils.isNotEmpty(this.after);
        }

        private boolean isLess(String name) {
            return Arrays.asList(this.before).contains(name);
        }

        private boolean isMore(String name) {
            return Arrays.asList(this.after).contains(name);
        }

        static /* synthetic */ String[] access$502(ActivateInfo x0, String[] x1) {
            x0.before = x1;
            return x1;
        }

        static /* synthetic */ String[] access$602(ActivateInfo x0, String[] x1) {
            x0.after = x1;
            return x1;
        }
    }
}

