/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.event;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.event.Event;

@SPI
@FunctionalInterface
public interface EventListener<E extends Event>
extends java.util.EventListener,
Prioritized {
    public void onEvent(E var1);

    @Override
    default public int getPriority() {
        return 0;
    }

    public static Class<? extends Event> findEventType(EventListener<?> listener) {
        return EventListener.findEventType(listener.getClass());
    }

    public static Class<? extends Event> findEventType(Class<?> listenerClass) {
        Class<Event> eventType = null;
        if (listenerClass != null && EventListener.class.isAssignableFrom(listenerClass)) {
            eventType = ReflectUtils.findParameterizedTypes(listenerClass).stream().map(EventListener::findEventType).filter(Objects::nonNull).findAny().orElse(EventListener.findEventType(listenerClass.getSuperclass()));
        }
        return eventType;
    }

    public static Class<? extends Event> findEventType(ParameterizedType parameterizedType) {
        Class eventType = null;
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class && EventListener.class.isAssignableFrom((Class)rawType)) {
            Type[] typeArguments;
            for (Type typeArgument : typeArguments = parameterizedType.getActualTypeArguments()) {
                Class argumentClass;
                if (!(typeArgument instanceof Class) || !Event.class.isAssignableFrom(argumentClass = (Class)typeArgument)) continue;
                eventType = argumentClass;
                break;
            }
        }
        return eventType;
    }
}

