/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.report.support;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.config.configcenter.DynamicConfigurationFactory;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;

public class ConfigCenterBasedMetadataReport
extends AbstractMetadataReport {
    private final KeyTypeEnum keyType;
    private final String group;
    private final DynamicConfiguration dynamicConfiguration;

    public ConfigCenterBasedMetadataReport(URL reportServerURL, KeyTypeEnum keyTypeEnum) {
        super(reportServerURL);
        this.keyType = keyTypeEnum;
        this.group = reportServerURL.getParameter("group", "dubbo");
        String extensionName = reportServerURL.getProtocol();
        DynamicConfigurationFactory dynamicConfigurationFactory = DynamicConfigurationFactory.getDynamicConfigurationFactory((String)extensionName);
        this.dynamicConfiguration = dynamicConfigurationFactory.getDynamicConfiguration(reportServerURL);
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.saveMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String serviceParameterString) {
        this.saveMetadata(consumerMetadataIdentifier, serviceParameterString);
    }

    @Override
    protected void doSaveMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.saveMetadata(metadataIdentifier, URL.encode((String)url.toFullString()));
    }

    @Override
    protected void doRemoveMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.removeMetadata(metadataIdentifier);
    }

    @Override
    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        throw new UnsupportedOperationException("doGetExportedURLs method will not be supported!");
    }

    @Override
    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urlListStr) {
        this.saveMetadata(subscriberMetadataIdentifier, urlListStr);
    }

    @Override
    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.getMetadata(subscriberMetadataIdentifier);
    }

    @Override
    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.getMetadata(metadataIdentifier);
    }

    @Override
    public boolean saveExportedURLs(String serviceName, String exportedServicesRevision, String exportedURLsContent) {
        String key = this.buildExportedURLsMetadataKey(serviceName, exportedServicesRevision);
        return this.dynamicConfiguration.publishConfig(key, this.group, exportedURLsContent);
    }

    @Override
    public String getExportedURLsContent(String serviceName, String exportedServicesRevision) {
        String key = this.buildExportedURLsMetadataKey(serviceName, exportedServicesRevision);
        return this.dynamicConfiguration.getConfig(key, this.group);
    }

    private String buildExportedURLsMetadataKey(String serviceName, String exportedServicesRevision) {
        return this.keyType.build("exported-urls", serviceName, exportedServicesRevision);
    }

    protected void saveMetadata(BaseMetadataIdentifier metadataIdentifier, String value) {
        String key = this.getKey(metadataIdentifier);
        this.dynamicConfiguration.publishConfig(key, this.group, value);
    }

    protected void saveMetadata(MetadataIdentifier metadataIdentifier, String value) {
        String key = this.getKey(metadataIdentifier);
        this.dynamicConfiguration.publishConfig(key, this.group, value);
    }

    protected String getMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        String key = this.getKey(metadataIdentifier);
        return this.dynamicConfiguration.getConfig(key, this.group);
    }

    protected String getMetadata(MetadataIdentifier metadataIdentifier) {
        String key = this.getKey(metadataIdentifier);
        return this.dynamicConfiguration.getConfig(key, this.group);
    }

    protected String getMetadata(SubscriberMetadataIdentifier metadataIdentifier) {
        String key = this.getKey(metadataIdentifier);
        return this.dynamicConfiguration.getConfig(key, this.group);
    }

    protected void removeMetadata(MetadataIdentifier metadataIdentifier) {
        String key = this.getKey(metadataIdentifier);
        this.dynamicConfiguration.removeConfig(key, this.group);
    }

    protected void removeMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        String key = this.getKey(metadataIdentifier);
        this.dynamicConfiguration.removeConfig(key, this.group);
    }

    protected String getKey(BaseMetadataIdentifier metadataIdentifier) {
        return metadataIdentifier.getUniqueKey(this.keyType);
    }

    protected String getKey(MetadataIdentifier metadataIdentifier) {
        return metadataIdentifier.getUniqueKey(this.keyType);
    }

    @Override
    protected void doClose() throws Exception {
        this.dynamicConfiguration.close();
    }
}

