/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.url.component.URLParam;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataParamsFilter;
import org.apache.dubbo.metadata.RevisionResolver;

public class MetadataInfo
implements Serializable {
    public static final MetadataInfo EMPTY = new MetadataInfo();
    private String app;
    private String revision;
    private Map<String, ServiceInfo> services;
    private transient Map<String, String> extendParams;
    private transient AtomicBoolean reported = new AtomicBoolean(false);

    public MetadataInfo() {
        this(null);
    }

    public MetadataInfo(String app) {
        this(app, null, null);
    }

    public MetadataInfo(String app, String revision, Map<String, ServiceInfo> services) {
        this.app = app;
        this.revision = revision;
        this.services = services == null ? new HashMap() : services;
        this.extendParams = new HashMap<String, String>();
    }

    public void addService(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        this.services.put(serviceInfo.getMatchKey(), serviceInfo);
        this.markChanged();
    }

    public void removeService(ServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        this.services.remove(serviceInfo.getMatchKey());
        this.markChanged();
    }

    public void removeService(String key) {
        if (key == null) {
            return;
        }
        this.services.remove(key);
        this.markChanged();
    }

    public String calAndGetRevision() {
        if (this.revision != null && this.hasReported()) {
            return this.revision;
        }
        if (CollectionUtils.isEmptyMap(this.services)) {
            this.revision = RevisionResolver.getEmptyRevision(this.app);
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(this.app);
            for (Map.Entry<String, ServiceInfo> entry : new TreeMap<String, ServiceInfo>(this.services).entrySet()) {
                sb.append(entry.getValue().toDescString());
            }
            this.revision = RevisionResolver.calRevision(sb.toString());
        }
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean hasReported() {
        return this.reported.get();
    }

    public void markReported() {
        this.reported.compareAndSet(false, true);
    }

    public void markChanged() {
        this.reported.compareAndSet(true, false);
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Map<String, ServiceInfo> getServices() {
        return this.services;
    }

    public void setServices(Map<String, ServiceInfo> services) {
        this.services = services;
    }

    public ServiceInfo getServiceInfo(String serviceKey) {
        return this.services.get(serviceKey);
    }

    public Map<String, String> getExtendParams() {
        return this.extendParams;
    }

    public String getParameter(String key, String serviceKey) {
        ServiceInfo serviceInfo = this.services.get(serviceKey);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.getParameter(key);
    }

    public Map<String, String> getParameters(String serviceKey) {
        ServiceInfo serviceInfo = this.services.get(serviceKey);
        if (serviceInfo == null) {
            return Collections.emptyMap();
        }
        return serviceInfo.getAllParams();
    }

    public String getServiceString(String protocolServiceKey) {
        if (protocolServiceKey == null) {
            return null;
        }
        ServiceInfo serviceInfo = this.services.get(protocolServiceKey);
        if (serviceInfo == null) {
            return null;
        }
        return serviceInfo.toString();
    }

    public String toString() {
        return "metadata{app='" + this.app + "',revision='" + this.revision + "',services=" + this.services + "}";
    }

    public static class ServiceInfo
    implements Serializable {
        private static ExtensionLoader<MetadataParamsFilter> loader = ExtensionLoader.getExtensionLoader(MetadataParamsFilter.class);
        private String name;
        private String group;
        private String version;
        private String protocol;
        private String path;
        private Map<String, String> params;
        private transient Map<String, String> consumerParams;
        private transient Map<String, Map<String, String>> methodParams;
        private transient Map<String, Map<String, String>> consumerMethodParams;
        private transient Map<String, Number> numbers;
        private transient Map<String, Map<String, Number>> methodNumbers;
        private transient String serviceKey;
        private transient String matchKey;
        private transient URL url;
        private static final String[] KEYS_TO_REMOVE = new String[]{"monitor", "bind.ip", "bind.port", "qos.enable", "qos.host", "qos.port", "qos.accept.foreign.ip", "validation", "interfaces", "pid", "timestamp"};

        public ServiceInfo() {
        }

        public ServiceInfo(URL url) {
            this(url.getServiceInterface(), url.getGroup(), url.getVersion(), url.getProtocol(), url.getPath(), null);
            this.url = url;
            HashMap<String, String> params = new HashMap<String, String>();
            List filters = loader.getActivateExtension(url, "params-filter");
            if (filters.size() == 0) {
                params.putAll(url.getParameters());
                for (String key : KEYS_TO_REMOVE) {
                    params.remove(key);
                }
            }
            for (MetadataParamsFilter filter : filters) {
                Object[] paramsIncluded = filter.serviceParamsIncluded();
                if (!ArrayUtils.isNotEmpty((Object[])paramsIncluded)) continue;
                for (Object p : paramsIncluded) {
                    String[] methods;
                    String value = url.getParameter((String)p);
                    if (StringUtils.isNotEmpty((String)value) && params.get(p) == null) {
                        params.put((String)p, value);
                    }
                    if ((methods = url.getParameter("methods", (String[])null)) == null) continue;
                    for (String method : methods) {
                        String mValue = url.getMethodParameterStrict(method, (String)p);
                        if (!StringUtils.isNotEmpty((String)mValue)) continue;
                        params.put(method + "." + (String)p, mValue);
                    }
                }
            }
            this.params = params;
        }

        public ServiceInfo(String name, String group, String version, String protocol, String path, Map<String, String> params) {
            this.name = name;
            this.group = group;
            this.version = version;
            this.protocol = protocol;
            this.path = path;
            this.params = params == null ? new HashMap() : params;
            this.serviceKey = URL.buildKey((String)name, (String)group, (String)version);
            this.matchKey = this.buildMatchKey();
        }

        public String getMatchKey() {
            if (this.matchKey != null) {
                return this.matchKey;
            }
            this.buildMatchKey();
            return this.matchKey;
        }

        private String buildMatchKey() {
            this.matchKey = this.getServiceKey();
            if (StringUtils.isNotEmpty((String)this.protocol)) {
                this.matchKey = this.getServiceKey() + ":" + this.protocol;
            }
            return this.matchKey;
        }

        public String getServiceKey() {
            if (this.serviceKey != null) {
                return this.serviceKey;
            }
            this.serviceKey = URL.buildKey((String)this.name, (String)this.group, (String)this.version);
            return this.serviceKey;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Map<String, String> getParams() {
            if (this.params == null) {
                return Collections.emptyMap();
            }
            return this.params;
        }

        public void setParams(Map<String, String> params) {
            this.params = params;
        }

        public Map<String, String> getAllParams() {
            if (this.consumerParams != null) {
                HashMap<String, String> allParams = new HashMap<String, String>((int)((float)(this.params.size() + this.consumerParams.size()) / 0.75f + 1.0f));
                allParams.putAll(this.params);
                allParams.putAll(this.consumerParams);
                return allParams;
            }
            return this.params;
        }

        public String getParameter(String key) {
            String value;
            if (this.consumerParams != null && (value = this.consumerParams.get(key)) != null) {
                return value;
            }
            return this.params.get(key);
        }

        public String getMethodParameter(String method, String key, String defaultValue) {
            String value;
            if (this.methodParams == null) {
                this.methodParams = URLParam.initMethodParameters(this.params);
                this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
            }
            if ((value = this.getMethodParameter(method, key, this.consumerMethodParams)) != null) {
                return value;
            }
            value = this.getMethodParameter(method, key, this.methodParams);
            return value == null ? defaultValue : value;
        }

        private String getMethodParameter(String method, String key, Map<String, Map<String, String>> map) {
            Map<String, String> keyMap;
            String value = null;
            if (map != null && (keyMap = map.get(method)) != null) {
                value = keyMap.get(key);
            }
            return value;
        }

        public boolean hasMethodParameter(String method, String key) {
            String value = this.getMethodParameter(method, key, (String)null);
            return StringUtils.isNotEmpty((String)value);
        }

        public boolean hasMethodParameter(String method) {
            if (this.methodParams == null) {
                this.methodParams = URLParam.initMethodParameters(this.params);
                this.consumerMethodParams = URLParam.initMethodParameters(this.consumerParams);
            }
            return this.consumerMethodParams.containsKey(method) || this.methodParams.containsKey(method);
        }

        public String toDescString() {
            return this.getMatchKey() + this.getMethodSignaturesString() + new TreeMap<String, String>(this.getParams());
        }

        private String getMethodSignaturesString() {
            Method[] methods;
            TreeSet<String> methodStrings = new TreeSet<String>();
            for (Method method : methods = ClassUtils.forName((String)this.name).getMethods()) {
                methodStrings.add(method.toString());
            }
            return ((Object)methodStrings).toString();
        }

        public void addParameter(String key, String value) {
            if (this.consumerParams != null) {
                this.consumerParams.put(key, value);
            }
        }

        public void addParameterIfAbsent(String key, String value) {
            if (this.consumerParams != null) {
                this.consumerParams.putIfAbsent(key, value);
            }
        }

        public void addConsumerParams(Map<String, String> params) {
            if (this.consumerParams == null) {
                this.consumerParams = new HashMap<String, String>(params);
            }
        }

        public Map<String, Number> getNumbers() {
            if (this.numbers == null) {
                this.numbers = new ConcurrentHashMap<String, Number>();
            }
            return this.numbers;
        }

        public Map<String, Map<String, Number>> getMethodNumbers() {
            if (this.methodNumbers == null) {
                this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
            }
            return this.methodNumbers;
        }

        public URL getUrl() {
            return this.url;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ServiceInfo)) {
                return false;
            }
            ServiceInfo serviceInfo = (ServiceInfo)obj;
            return Objects.equals(this.getVersion(), serviceInfo.getVersion()) && Objects.equals(this.getGroup(), serviceInfo.getGroup()) && Objects.equals(this.getName(), serviceInfo.getName()) && Objects.equals(this.getProtocol(), serviceInfo.getProtocol());
        }

        public int hashCode() {
            return Objects.hash(this.getVersion(), this.getGroup(), this.getName(), this.getProtocol());
        }

        public String toString() {
            return "service{name='" + this.name + "',group='" + this.group + "',version='" + this.version + "',protocol='" + this.protocol + "',params=" + this.params + ",consumerParams=" + this.consumerParams + "}";
        }
    }
}

