/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.zookeeper;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MappingChangedEvent;
import org.apache.dubbo.metadata.MappingListener;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.report.identifier.BaseMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.KeyTypeEnum;
import org.apache.dubbo.metadata.report.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.ServiceMetadataIdentifier;
import org.apache.dubbo.metadata.report.identifier.SubscriberMetadataIdentifier;
import org.apache.dubbo.metadata.report.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.zookeeper.ChildListener;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;

public class ZookeeperMetadataReport
extends AbstractMetadataReport {
    private final String root;
    final ZookeeperClient zkClient;
    private Gson gson = new Gson();
    private Map<String, ChildListener> listenerMap = new ConcurrentHashMap<String, ChildListener>();

    public ZookeeperMetadataReport(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", "dubbo");
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    protected void doSaveMetadata(ServiceMetadataIdentifier metadataIdentifier, URL url) {
        this.zkClient.create(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier), URL.encode((String)url.toFullString()), false);
    }

    protected void doRemoveMetadata(ServiceMetadataIdentifier metadataIdentifier) {
        this.zkClient.delete(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
    }

    protected List<String> doGetExportedURLs(ServiceMetadataIdentifier metadataIdentifier) {
        String content = this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(URL.decode((String)content)));
    }

    protected void doSaveSubscriberData(SubscriberMetadataIdentifier subscriberMetadataIdentifier, String urls) {
        this.zkClient.create(this.getNodePath((BaseMetadataIdentifier)subscriberMetadataIdentifier), urls, false);
    }

    protected String doGetSubscribedURLs(SubscriberMetadataIdentifier subscriberMetadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)subscriberMetadataIdentifier));
    }

    public String getServiceDefinition(MetadataIdentifier metadataIdentifier) {
        return this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier));
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        this.zkClient.create(this.getNodePath((BaseMetadataIdentifier)metadataIdentifier), v, false);
    }

    String getNodePath(BaseMetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(KeyTypeEnum.PATH);
    }

    public void publishAppMetadata(SubscriberMetadataIdentifier identifier, MetadataInfo metadataInfo) {
        String path = this.getNodePath((BaseMetadataIdentifier)identifier);
        if (StringUtils.isBlank((CharSequence)this.zkClient.getContent(path))) {
            this.zkClient.create(path, this.gson.toJson((Object)metadataInfo), false);
        }
    }

    public void registerServiceAppMapping(String serviceKey, String application, URL url) {
        String path = this.toRootDir() + serviceKey + "/" + application;
        if (StringUtils.isBlank((CharSequence)this.zkClient.getContent(path))) {
            HashMap<String, String> value = new HashMap<String, String>();
            value.put("timestamp", String.valueOf(System.currentTimeMillis()));
            this.zkClient.create(path, this.gson.toJson(value), false);
        }
    }

    public MetadataInfo getAppMetadata(SubscriberMetadataIdentifier identifier, Map<String, String> instanceMetadata) {
        String content = this.zkClient.getContent(this.getNodePath((BaseMetadataIdentifier)identifier));
        return (MetadataInfo)this.gson.fromJson(content, MetadataInfo.class);
    }

    public Set<String> getServiceAppMapping(String serviceKey, MappingListener listener, URL url) {
        List<String> appNameList;
        HashSet<String> appNameSet = new HashSet<String>();
        String path = this.toRootDir() + serviceKey;
        if (null == this.listenerMap.get(path)) {
            this.zkClient.create(path, false);
            appNameList = this.addServiceMappingListener(path, serviceKey, listener);
        } else {
            appNameList = this.zkClient.getChildren(path);
        }
        if (!CollectionUtils.isEmpty((Collection)appNameList)) {
            appNameSet.addAll(appNameList);
        }
        return appNameSet;
    }

    private List<String> addServiceMappingListener(String path, final String serviceKey, final MappingListener listener) {
        ChildListener zkListener = new ChildListener(){

            public void childChanged(String path, List<String> children) {
                MappingChangedEvent event = new MappingChangedEvent();
                event.setServiceKey(serviceKey);
                event.setApps((Set)(null != children ? new HashSet<String>(children) : null));
                listener.onEvent(event);
            }
        };
        List childNodes = this.zkClient.addChildListener(path, zkListener);
        this.listenerMap.put(path, zkListener);
        return childNodes;
    }
}

