/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.registry.AddressListener;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.client.InstanceAddressURL;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.cluster.Directory;

public class ServiceDiscoveryRegistryDirectory<T>
extends DynamicDirectory<T>
implements NotifyListener {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDiscoveryRegistryDirectory.class);
    private volatile Map<String, Invoker<T>> urlInvokerMap;
    private ServiceInstancesChangedListener listener;

    public ServiceDiscoveryRegistryDirectory(Class<T> serviceType, URL url) {
        super(serviceType, url);
    }

    public boolean isAvailable() {
        if (this.isDestroyed()) {
            return false;
        }
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null && localUrlInvokerMap.size() > 0) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                if (!invoker.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public synchronized void notify(List<URL> instanceUrls) {
        RpcContext.setRpcContext((URL)this.getConsumerUrl());
        ExtensionLoader addressListenerExtensionLoader = ExtensionLoader.getExtensionLoader(AddressListener.class);
        List supportedListeners = addressListenerExtensionLoader.getActivateExtension(this.getUrl(), (String[])null);
        if (supportedListeners != null && !supportedListeners.isEmpty()) {
            for (AddressListener addressListener : supportedListeners) {
                instanceUrls = addressListener.notify(instanceUrls, this.getConsumerUrl(), (Directory)this);
            }
        }
        this.refreshInvoker(instanceUrls);
    }

    private void refreshInvoker(List<URL> invokerUrls) {
        Assert.notNull(invokerUrls, (String)"invokerUrls should not be null, use empty url list to clear address.");
        if (invokerUrls.size() == 0) {
            this.forbidden = true;
            this.invokers = Collections.emptyList();
            this.routerChain.setInvokers(this.invokers);
            this.destroyAllInvokers();
            return;
        }
        this.forbidden = false;
        Map<String, Invoker<T>> oldUrlInvokerMap = this.urlInvokerMap;
        if (CollectionUtils.isEmpty(invokerUrls)) {
            return;
        }
        Map<String, Invoker<T>> newUrlInvokerMap = this.toInvokers(invokerUrls);
        if (CollectionUtils.isEmptyMap(newUrlInvokerMap)) {
            logger.error((Throwable)new IllegalStateException("Cannot create invokers from url address list (total " + invokerUrls.size() + ")"));
            return;
        }
        List<Invoker<T>> newInvokers = Collections.unmodifiableList(new ArrayList<Invoker<T>>(newUrlInvokerMap.values()));
        this.routerChain.setInvokers(newInvokers);
        this.invokers = this.multiGroup ? this.toMergeInvokerList(newInvokers) : newInvokers;
        this.urlInvokerMap = newUrlInvokerMap;
        if (oldUrlInvokerMap != null) {
            try {
                this.destroyUnusedInvokers(oldUrlInvokerMap, newUrlInvokerMap);
            }
            catch (Exception e) {
                logger.warn("destroyUnusedInvokers error. ", (Throwable)e);
            }
        }
        this.invokersChanged();
    }

    private Map<String, Invoker<T>> toInvokers(List<URL> urls) {
        HashMap<String, Invoker<T>> newUrlInvokerMap = new HashMap<String, Invoker<T>>();
        if (urls == null || urls.isEmpty()) {
            return newUrlInvokerMap;
        }
        for (URL url : urls) {
            Invoker invoker;
            InstanceAddressURL instanceAddressURL = (InstanceAddressURL)url;
            if ("empty".equals(instanceAddressURL.getProtocol())) continue;
            if (!ExtensionLoader.getExtensionLoader(Protocol.class).hasExtension(instanceAddressURL.getProtocol())) {
                logger.error((Throwable)new IllegalStateException("Unsupported protocol " + instanceAddressURL.getProtocol() + " in notified url: " + (Object)((Object)instanceAddressURL) + " from registry " + this.getUrl().getAddress() + " to consumer " + NetUtils.getLocalHost() + ", supported protocol: " + ExtensionLoader.getExtensionLoader(Protocol.class).getSupportedExtensions()));
                continue;
            }
            instanceAddressURL.addConsumerParams(this.getConsumerUrl().getProtocolServiceKey(), this.queryMap);
            Invoker invoker2 = invoker = this.urlInvokerMap == null ? null : this.urlInvokerMap.get(instanceAddressURL.getAddress());
            if (invoker == null || this.urlChanged(invoker, instanceAddressURL)) {
                try {
                    boolean enabled = true;
                    enabled = instanceAddressURL.hasParameter("disabled") ? !instanceAddressURL.getParameter("disabled", false) : instanceAddressURL.getParameter("enabled", true);
                    if (enabled) {
                        invoker = this.protocol.refer(this.serviceType, (URL)instanceAddressURL);
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to refer invoker for interface:" + this.serviceType + ",url:(" + (Object)((Object)instanceAddressURL) + ")" + t.getMessage(), t);
                }
                if (invoker == null) continue;
                newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
                continue;
            }
            newUrlInvokerMap.put(instanceAddressURL.getAddress(), invoker);
        }
        return newUrlInvokerMap;
    }

    private boolean urlChanged(Invoker<T> invoker, InstanceAddressURL newURL) {
        InstanceAddressURL oldURL = (InstanceAddressURL)invoker.getUrl();
        if (!newURL.getInstance().equals(oldURL.getInstance())) {
            return true;
        }
        return !oldURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()).equals((Object)newURL.getMetadataInfo().getServiceInfo(this.getConsumerUrl().getProtocolServiceKey()));
    }

    private List<Invoker<T>> toMergeInvokerList(List<Invoker<T>> invokers) {
        return invokers;
    }

    @Override
    protected void destroyAllInvokers() {
        Map<String, Invoker<T>> localUrlInvokerMap = this.urlInvokerMap;
        if (localUrlInvokerMap != null) {
            for (Invoker<T> invoker : new ArrayList<Invoker<T>>(localUrlInvokerMap.values())) {
                try {
                    invoker.destroy();
                }
                catch (Throwable t) {
                    logger.warn("Failed to destroy service " + this.serviceKey + " to provider " + invoker.getUrl(), t);
                }
            }
            localUrlInvokerMap.clear();
        }
        this.invokers = null;
    }

    private void destroyUnusedInvokers(Map<String, Invoker<T>> oldUrlInvokerMap, Map<String, Invoker<T>> newUrlInvokerMap) {
        if (newUrlInvokerMap == null || newUrlInvokerMap.size() == 0) {
            this.destroyAllInvokers();
            return;
        }
        ArrayList<String> deleted = null;
        if (oldUrlInvokerMap != null) {
            Collection<Invoker<T>> newInvokers = newUrlInvokerMap.values();
            for (Map.Entry<String, Invoker<T>> entry : oldUrlInvokerMap.entrySet()) {
                if (newInvokers.contains(entry.getValue())) continue;
                if (deleted == null) {
                    deleted = new ArrayList<String>();
                }
                deleted.add(entry.getKey());
            }
        }
        if (deleted != null) {
            for (String addressKey : deleted) {
                Invoker<T> invoker;
                if (addressKey == null || (invoker = oldUrlInvokerMap.remove(addressKey)) == null) continue;
                try {
                    invoker.destroy();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("destroy invoker[" + invoker.getUrl() + "] success. ");
                }
                catch (Exception e) {
                    logger.warn("destroy invoker[" + invoker.getUrl() + "] failed. " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

