/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.config.configcenter.ConfigChangeType;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.configurator.parser.ConfigParser;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;

public abstract class AbstractConfiguratorListener
implements ConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfiguratorListener.class);
    protected List<Configurator> configurators = Collections.emptyList();

    protected final void initWith(String key) {
        GovernanceRuleRepository ruleRepository = (GovernanceRuleRepository)ExtensionLoader.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension();
        ruleRepository.addListener(key, (ConfigurationListener)this);
        String rawConfig = ruleRepository.getRule(key, "dubbo");
        if (!StringUtils.isEmpty((String)rawConfig)) {
            this.genConfiguratorsFromRawRule(rawConfig);
        }
    }

    public void process(ConfigChangedEvent event) {
        if (logger.isInfoEnabled()) {
            logger.info("Notification of overriding rule, change type is: " + event.getChangeType() + ", raw config content is:\n " + event.getContent());
        }
        if (event.getChangeType().equals((Object)ConfigChangeType.DELETED)) {
            this.configurators.clear();
        } else if (!this.genConfiguratorsFromRawRule(event.getContent())) {
            return;
        }
        this.notifyOverrides();
    }

    private boolean genConfiguratorsFromRawRule(String rawConfig) {
        boolean parseSuccess = true;
        try {
            this.configurators = Configurator.toConfigurators((List)ConfigParser.parseConfigurators((String)rawConfig)).orElse(this.configurators);
        }
        catch (Exception e) {
            logger.error("Failed to parse raw dynamic config and it will not take effect, the raw config is: " + rawConfig, (Throwable)e);
            parseSuccess = false;
        }
        return parseSuccess;
    }

    protected abstract void notifyOverrides();

    public List<Configurator> getConfigurators() {
        return this.configurators;
    }

    public void setConfigurators(List<Configurator> configurators) {
        this.configurators = configurators;
    }
}

