/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.Experimental;
import org.apache.dubbo.rpc.AttachmentsAdapter;
import org.apache.dubbo.rpc.RpcContext;

public class RpcContextAttachment
extends RpcContext {
    protected final Map<String, Object> attachments = new HashMap<String, Object>();
    private final Map<String, Object> values = new HashMap<String, Object>();

    protected RpcContextAttachment() {
    }

    @Override
    public String getAttachment(String key) {
        Object value = this.attachments.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    @Experimental(value="Experiment api for supporting Object transmission")
    public Object getObjectAttachment(String key) {
        return this.attachments.get(key);
    }

    @Override
    public RpcContextAttachment setAttachment(String key, String value) {
        return this.setObjectAttachment(key, value);
    }

    @Override
    public RpcContextAttachment setAttachment(String key, Object value) {
        return this.setObjectAttachment(key, value);
    }

    @Override
    @Experimental(value="Experiment api for supporting Object transmission")
    public RpcContextAttachment setObjectAttachment(String key, Object value) {
        if (value == null) {
            this.attachments.remove(key);
        } else {
            this.attachments.put(key, value);
        }
        return this;
    }

    @Override
    public RpcContextAttachment removeAttachment(String key) {
        this.attachments.remove(key);
        return this;
    }

    @Override
    @Deprecated
    public Map<String, String> getAttachments() {
        return new AttachmentsAdapter.ObjectToStringMap(this.getObjectAttachments());
    }

    @Override
    @Experimental(value="Experiment api for supporting Object transmission")
    public Map<String, Object> getObjectAttachments() {
        return this.attachments;
    }

    @Override
    public RpcContextAttachment setAttachments(Map<String, String> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    @Override
    @Experimental(value="Experiment api for supporting Object transmission")
    public RpcContextAttachment setObjectAttachments(Map<String, Object> attachment) {
        this.attachments.clear();
        if (attachment != null && attachment.size() > 0) {
            this.attachments.putAll(attachment);
        }
        return this;
    }

    @Override
    public void clearAttachments() {
        this.attachments.clear();
    }

    @Override
    @Deprecated
    public Map<String, Object> get() {
        return this.getObjectAttachments();
    }

    @Override
    @Deprecated
    public RpcContextAttachment set(String key, Object value) {
        return this.setAttachment(key, value);
    }

    @Override
    @Deprecated
    public RpcContextAttachment remove(String key) {
        return this.removeAttachment(key);
    }

    @Override
    @Deprecated
    public Object get(String key) {
        return this.getAttachment(key);
    }
}

