/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import java.util.Set;
import org.apache.dubbo.config.spring.beans.factory.annotation.ServiceAnnotationPostProcessor;
import org.apache.dubbo.config.spring.context.DubboBootstrapApplicationListener;
import org.apache.dubbo.config.spring.context.annotation.EnableDubboConfig;
import org.apache.dubbo.spring.boot.autoconfigure.DubboConfigurationProperties;
import org.apache.dubbo.spring.boot.autoconfigure.DubboRelaxedBindingAutoConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@Configuration
@AutoConfigureAfter(value={DubboRelaxedBindingAutoConfiguration.class})
@EnableConfigurationProperties(value={DubboConfigurationProperties.class})
@EnableDubboConfig
public class DubboAutoConfiguration
implements ApplicationContextAware,
BeanDefinitionRegistryPostProcessor {
    @ConditionalOnProperty(prefix="dubbo.scan.", name={"base-packages"})
    @ConditionalOnBean(name={"dubbo-service-class-base-packages"})
    @Bean
    public ServiceAnnotationPostProcessor serviceAnnotationBeanProcessor(@Qualifier(value="dubbo-service-class-base-packages") Set<String> packagesToScan) {
        return new ServiceAnnotationPostProcessor(packagesToScan);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
            DubboBootstrapApplicationListener dubboBootstrapApplicationListener = new DubboBootstrapApplicationListener();
            dubboBootstrapApplicationListener.setApplicationContext(applicationContext);
            context.addApplicationListener((ApplicationListener)dubboBootstrapApplicationListener);
        }
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        this.removeBeanDefinition(registry, "dubboLifecycleComponentApplicationListener");
        this.removeBeanDefinition(registry, "dubboBootstrapApplicationListener");
    }

    private void removeBeanDefinition(BeanDefinitionRegistry registry, String beanName) {
        if (registry.containsBeanDefinition(beanName)) {
            registry.removeBeanDefinition(beanName);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

