/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.DataTypeCqlNameParser;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.VersionNumber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.cassandra.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.cassandra.shaded.com.google.common.collect.Iterators;

public class UserType
extends DataType
implements Iterable<Field> {
    static final String TYPE_NAME = "type_name";
    private static final String COLS_NAMES = "field_names";
    static final String COLS_TYPES = "field_types";
    private final String keyspace;
    private final String typeName;
    private final ProtocolVersion protocolVersion;
    private volatile CodecRegistry codecRegistry;
    final Field[] byIdx;
    final Map<String, int[]> byName;

    UserType(String keyspace, String typeName, Collection<Field> fields, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        super(DataType.Name.UDT);
        this.keyspace = keyspace;
        this.typeName = typeName;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.byIdx = fields.toArray(new Field[fields.size()]);
        ImmutableMap.Builder<String, int[]> builder = new ImmutableMap.Builder<String, int[]>();
        for (int i = 0; i < this.byIdx.length; ++i) {
            builder.put(this.byIdx[i].getName(), new int[]{i});
        }
        this.byName = builder.build();
    }

    static UserType build(KeyspaceMetadata ksm, Row row, VersionNumber version, Cluster cluster, Map<String, UserType> userTypes) {
        ProtocolVersion protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        String keyspace = row.getString("keyspace_name");
        String name = row.getString(TYPE_NAME);
        List<String> fieldNames = row.getList(COLS_NAMES, String.class);
        List<String> fieldTypes = row.getList(COLS_TYPES, String.class);
        ArrayList<Field> fields = new ArrayList<Field>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            DataType fieldType = (double)version.getMajor() >= 3.0 ? DataTypeCqlNameParser.parse(fieldTypes.get(i), cluster, ksm.getName(), userTypes, ksm.userTypes, false, false) : DataTypeClassNameParser.parseOne(fieldTypes.get(i), protocolVersion, codecRegistry);
            fields.add(new Field(fieldNames.get(i), fieldType));
        }
        return new UserType(keyspace, name, fields, protocolVersion, codecRegistry);
    }

    public UDTValue newValue() {
        return new UDTValue(this);
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.byName.containsKey(Metadata.handleId(name));
    }

    @Override
    public Iterator<Field> iterator() {
        return Iterators.forArray(this.byIdx);
    }

    public Collection<String> getFieldNames() {
        return this.byName.keySet();
    }

    public DataType getFieldType(String name) {
        int[] idx = this.byName.get(Metadata.handleId(name));
        if (idx == null) {
            throw new IllegalArgumentException(name + " is not a field defined in this definition");
        }
        return this.byIdx[idx[0]].getType();
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.keyspace.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.byIdx);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UserType)) {
            return false;
        }
        UserType other = (UserType)o;
        return this.name.equals((Object)other.name) && this.keyspace.equals(other.keyspace) && this.typeName.equals(other.typeName) && Arrays.equals(this.byIdx, other.byIdx);
    }

    public String exportAsString() {
        return this.asCQLQuery(true);
    }

    public String asCQLQuery() {
        return this.asCQLQuery(false);
    }

    ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    void setCodecRegistry(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    private String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TYPE ").append(Metadata.escapeId(this.keyspace)).append('.').append(Metadata.escapeId(this.typeName)).append(" (");
        TableMetadata.newLine(sb, formatted);
        for (int i = 0; i < this.byIdx.length; ++i) {
            sb.append(TableMetadata.spaces(4, formatted)).append(this.byIdx[i]);
            if (i < this.byIdx.length - 1) {
                sb.append(',');
            }
            TableMetadata.newLine(sb, formatted);
        }
        return sb.append(");").toString();
    }

    public String toString() {
        return "frozen<" + Metadata.escapeId(this.getKeyspace()) + '.' + Metadata.escapeId(this.getTypeName()) + ">";
    }

    @Override
    public String asFunctionParameterString() {
        return Metadata.escapeId(this.getTypeName());
    }

    static class Shallow
    extends DataType {
        final String keyspaceName;
        final String typeName;

        Shallow(String keyspaceName, String typeName) {
            super(DataType.Name.UDT);
            this.keyspaceName = keyspaceName;
            this.typeName = typeName;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }
    }

    public static class Field {
        private final String name;
        private final DataType type;

        Field(String name, DataType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Field)) {
                return false;
            }
            Field other = (Field)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        public String toString() {
            return Metadata.escapeId(this.name) + ' ' + this.type;
        }
    }
}

