/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.MappingManager;
import java.nio.ByteBuffer;
import java.util.Map;

class MappedUDTCodec<T>
extends TypeCodec.AbstractUDTCodec<T> {
    private final UserType cqlUserType;
    private final Class<T> udtClass;
    private final Map<String, ColumnMapper<T>> columnMappers;
    private final CodecRegistry codecRegistry;

    public MappedUDTCodec(UserType cqlUserType, Class<T> udtClass, Map<String, ColumnMapper<T>> columnMappers, MappingManager mappingManager) {
        super(cqlUserType, udtClass);
        this.cqlUserType = cqlUserType;
        this.udtClass = udtClass;
        this.columnMappers = columnMappers;
        this.codecRegistry = mappingManager.getSession().getCluster().getConfiguration().getCodecRegistry();
    }

    @Override
    protected T newInstance() {
        try {
            return this.udtClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error creating instance of @UDT-annotated class " + this.udtClass, e);
        }
    }

    @Override
    protected ByteBuffer serializeField(T source, String fieldName, ProtocolVersion protocolVersion) {
        ColumnMapper<T> columnMapper;
        if (!fieldName.startsWith("\"")) {
            fieldName = Metadata.quote(fieldName);
        }
        if ((columnMapper = this.columnMappers.get(fieldName)) == null) {
            return null;
        }
        Object value = columnMapper.getValue(source);
        TypeCodec<Object> codec = columnMapper.getCustomCodec();
        if (codec == null) {
            codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(columnMapper.getColumnName()), columnMapper.getJavaType());
        }
        return codec.serialize(value, protocolVersion);
    }

    @Override
    protected T deserializeAndSetField(ByteBuffer input, T target, String fieldName, ProtocolVersion protocolVersion) {
        ColumnMapper<T> columnMapper;
        if (!fieldName.startsWith("\"")) {
            fieldName = Metadata.quote(fieldName);
        }
        if ((columnMapper = this.columnMappers.get(fieldName)) != null) {
            TypeCodec<Object> codec = columnMapper.getCustomCodec();
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(columnMapper.getColumnName()), columnMapper.getJavaType());
            }
            columnMapper.setValue(target, codec.deserialize(input, protocolVersion));
        }
        return target;
    }

    @Override
    protected String formatField(T source, String fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected T parseAndSetField(String input, T target, String fieldName) {
        throw new UnsupportedOperationException();
    }
}

