/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.io.IOException;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.batch.connectors.cassandra.CassandraInputFormatBase;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;

public class CassandraInputFormat<OUT extends Tuple>
extends CassandraInputFormatBase<OUT> {
    private static final long serialVersionUID = 3642323148032444264L;
    private transient ResultSet resultSet;

    public CassandraInputFormat(String query, ClusterBuilder builder) {
        super(query, builder);
    }

    public void open(InputSplit ignored) throws IOException {
        this.session = this.cluster.connect();
        this.resultSet = this.session.execute(this.query);
    }

    public boolean reachedEnd() throws IOException {
        return this.resultSet.isExhausted();
    }

    public OUT nextRecord(OUT reuse) throws IOException {
        Row item = this.resultSet.one();
        for (int i = 0; i < reuse.getArity(); ++i) {
            reuse.setField(item.getObject(i), i);
        }
        return reuse;
    }
}

