/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.io.NonParallelInput;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.io.statistics.BaseStatistics;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.GenericInputSplit;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.shaded.guava18.com.google.common.base.Strings;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CassandraInputFormatBase<OUT>
extends RichInputFormat<OUT, InputSplit>
implements NonParallelInput {
    private static final long serialVersionUID = -1519372881115104601L;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String query;
    private final ClusterBuilder builder;
    protected transient Cluster cluster;
    protected transient Session session;

    public CassandraInputFormatBase(String query, ClusterBuilder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)query) ? 1 : 0) != 0, (Object)"Query cannot be null or empty");
        Preconditions.checkNotNull((Object)builder, (String)"Builder cannot be null");
        this.query = query;
        this.builder = builder;
    }

    public void configure(Configuration parameters) {
        this.cluster = this.builder.getCluster();
    }

    public BaseStatistics getStatistics(BaseStatistics cachedStatistics) {
        return cachedStatistics;
    }

    public InputSplit[] createInputSplits(int minNumSplits) {
        return new GenericInputSplit[]{new GenericInputSplit(0, 1)};
    }

    public InputSplitAssigner getInputSplitAssigner(InputSplit[] inputSplits) {
        return new DefaultInputSplitAssigner(inputSplits);
    }

    public void close() {
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error while closing session.", (Throwable)e);
        }
        try {
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (Exception e) {
            this.logger.error("Error while closing cluster.", (Throwable)e);
        }
    }
}

