/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.cassandra;

import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import org.apache.flink.batch.connectors.cassandra.CassandraInputFormatBase;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.connectors.cassandra.MapperOptions;
import org.apache.flink.util.Preconditions;

public class CassandraPojoInputFormat<OUT>
extends CassandraInputFormatBase<OUT> {
    private static final long serialVersionUID = 1992091320180905115L;
    private transient Result<OUT> resultSet;
    private final MapperOptions mapperOptions;
    private final Class<OUT> inputClass;

    public CassandraPojoInputFormat(String query, ClusterBuilder builder, Class<OUT> inputClass) {
        this(query, builder, inputClass, null);
    }

    public CassandraPojoInputFormat(String query, ClusterBuilder builder, Class<OUT> inputClass, MapperOptions mapperOptions) {
        super(query, builder);
        this.mapperOptions = mapperOptions;
        this.inputClass = (Class)Preconditions.checkNotNull(inputClass, (String)"InputClass cannot be null");
    }

    public void open(InputSplit split) {
        Mapper.Option[] optionsArray;
        this.session = this.cluster.connect();
        MappingManager manager = new MappingManager(this.session);
        Mapper<OUT> mapper = manager.mapper(this.inputClass);
        if (this.mapperOptions != null && (optionsArray = this.mapperOptions.getMapperOptions()) != null) {
            mapper.setDefaultGetOptions(optionsArray);
        }
        this.resultSet = mapper.map(this.session.execute(this.query));
    }

    public boolean reachedEnd() {
        return this.resultSet.isExhausted();
    }

    public OUT nextRecord(OUT reuse) {
        return this.resultSet.one();
    }
}

