/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.batch.connectors.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import java.io.IOException;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.connectors.cassandra.MapperOptions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraPojoOutputFormat<OUT>
extends RichOutputFormat<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPojoOutputFormat.class);
    private static final long serialVersionUID = -1701885135103942460L;
    private final ClusterBuilder builder;
    private final MapperOptions mapperOptions;
    private final Class<OUT> outputClass;
    private transient Cluster cluster;
    private transient Session session;
    private transient Mapper<OUT> mapper;
    private transient FutureCallback<Void> callback;
    private transient Throwable exception = null;

    public CassandraPojoOutputFormat(ClusterBuilder builder, Class<OUT> outputClass) {
        this(builder, outputClass, null);
    }

    public CassandraPojoOutputFormat(ClusterBuilder builder, Class<OUT> outputClass, MapperOptions mapperOptions) {
        Preconditions.checkNotNull(outputClass, (String)"OutputClass cannot be null");
        Preconditions.checkNotNull((Object)builder, (String)"Builder cannot be null");
        this.builder = builder;
        this.mapperOptions = mapperOptions;
        this.outputClass = outputClass;
    }

    public void configure(Configuration parameters) {
        this.cluster = this.builder.getCluster();
    }

    public void open(int taskNumber, int numTasks) {
        Mapper.Option[] optionsArray;
        this.session = this.cluster.connect();
        MappingManager mappingManager = new MappingManager(this.session);
        this.mapper = mappingManager.mapper(this.outputClass);
        if (this.mapperOptions != null && (optionsArray = this.mapperOptions.getMapperOptions()) != null) {
            this.mapper.setDefaultSaveOptions(optionsArray);
        }
        this.callback = new FutureCallback<Void>(){

            @Override
            public void onSuccess(Void ignored) {
                CassandraPojoOutputFormat.this.onWriteSuccess();
            }

            @Override
            public void onFailure(Throwable t) {
                CassandraPojoOutputFormat.this.onWriteFailure(t);
            }
        };
    }

    public void writeRecord(OUT record) throws IOException {
        if (this.exception != null) {
            throw new IOException("write record failed", this.exception);
        }
        ListenableFuture<Void> result = this.mapper.saveAsync(record);
        Futures.addCallback(result, this.callback);
    }

    protected void onWriteSuccess() {
    }

    protected void onWriteFailure(Throwable t) {
        this.exception = t;
    }

    public void close() {
        this.mapper = null;
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while closing session.", (Throwable)e);
        }
        try {
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while closing cluster.", (Throwable)e);
        }
    }
}

