/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.cassandra.CassandraFailureHandler;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBase;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBaseConfig;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;

public abstract class AbstractCassandraTupleSink<IN>
extends CassandraSinkBase<IN, ResultSet> {
    private final String insertQuery;
    private transient PreparedStatement ps;
    private final boolean ignoreNullFields;

    public AbstractCassandraTupleSink(String insertQuery, ClusterBuilder builder, CassandraSinkBaseConfig config, CassandraFailureHandler failureHandler) {
        super(builder, config, failureHandler);
        this.insertQuery = insertQuery;
        this.ignoreNullFields = config.getIgnoreNullFields();
    }

    @Override
    public void open(Configuration configuration) {
        super.open(configuration);
        this.ps = this.session.prepare(this.insertQuery);
    }

    @Override
    public ListenableFuture<ResultSet> send(IN value) {
        Object[] fields = this.extract(value);
        return this.session.executeAsync(this.bind(fields));
    }

    private BoundStatement bind(Object[] fields) {
        BoundStatement bs = this.ps.bind(fields);
        if (this.ignoreNullFields) {
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i] != null) continue;
                bs.unset(i);
            }
        }
        return bs;
    }

    protected abstract Object[] extract(IN var1);
}

