/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import java.util.Properties;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.connectors.cassandra.CassandraRowSink;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBaseConfig;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.connectors.cassandra.NoOpCassandraFailureHandler;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.utils.TableConnectorUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class CassandraAppendTableSink
implements AppendStreamTableSink<Row> {
    private final ClusterBuilder builder;
    private final String cql;
    private String[] fieldNames;
    private TypeInformation[] fieldTypes;
    private final Properties properties;

    public CassandraAppendTableSink(ClusterBuilder builder, String cql) {
        this.builder = (ClusterBuilder)Preconditions.checkNotNull((Object)builder, (String)"ClusterBuilder must not be null.");
        this.cql = (String)Preconditions.checkNotNull((Object)cql, (String)"CQL query must not be null.");
        this.properties = new Properties();
    }

    public CassandraAppendTableSink(ClusterBuilder builder, String cql, Properties properties) {
        this.builder = (ClusterBuilder)Preconditions.checkNotNull((Object)builder, (String)"ClusterBuilder must not be null.");
        this.cql = (String)Preconditions.checkNotNull((Object)cql, (String)"CQL query must not be null.");
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
    }

    public TypeInformation<Row> getOutputType() {
        return new RowTypeInfo(this.fieldTypes);
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    public CassandraAppendTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        CassandraAppendTableSink cassandraTableSink = new CassandraAppendTableSink(this.builder, this.cql, this.properties);
        cassandraTableSink.fieldNames = (String[])Preconditions.checkNotNull((Object)fieldNames, (String)"Field names must not be null.");
        cassandraTableSink.fieldTypes = (TypeInformation[])Preconditions.checkNotNull(fieldTypes, (String)"Field types must not be null.");
        Preconditions.checkArgument((fieldNames.length == fieldTypes.length ? 1 : 0) != 0, (Object)"Number of provided field names and types does not match.");
        return cassandraTableSink;
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Row> dataStream) {
        if (!(dataStream.getType() instanceof RowTypeInfo)) {
            throw new TableException("No support for the type of the given DataStream: " + dataStream.getType());
        }
        CassandraRowSink sink = new CassandraRowSink(dataStream.getType().getArity(), this.cql, this.builder, CassandraSinkBaseConfig.newBuilder().build(), new NoOpCassandraFailureHandler());
        return dataStream.addSink((SinkFunction)sink).setParallelism(dataStream.getParallelism()).name(TableConnectorUtils.generateRuntimeName(this.getClass(), (String[])this.fieldNames));
    }

    public void emitDataStream(DataStream<Row> dataStream) {
        this.consumeDataStream(dataStream);
    }
}

