/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import javax.annotation.Nullable;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.ListenableFuture;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.connectors.cassandra.CassandraFailureHandler;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBase;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBaseConfig;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.connectors.cassandra.MapperOptions;
import org.apache.flink.streaming.connectors.cassandra.NoOpCassandraFailureHandler;

public class CassandraPojoSink<IN>
extends CassandraSinkBase<IN, ResultSet> {
    private static final long serialVersionUID = 1L;
    protected final Class<IN> clazz;
    private final MapperOptions options;
    private final String keyspace;
    protected transient Mapper<IN> mapper;
    protected transient MappingManager mappingManager;

    public CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder) {
        this(clazz, builder, null, null);
    }

    public CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder, @Nullable MapperOptions options) {
        this(clazz, builder, options, null);
    }

    public CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder, String keyspace) {
        this(clazz, builder, null, keyspace);
    }

    public CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder, @Nullable MapperOptions options, String keyspace) {
        this(clazz, builder, options, keyspace, CassandraSinkBaseConfig.newBuilder().build());
    }

    CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder, @Nullable MapperOptions options, String keyspace, CassandraSinkBaseConfig config) {
        this(clazz, builder, options, keyspace, config, new NoOpCassandraFailureHandler());
    }

    CassandraPojoSink(Class<IN> clazz, ClusterBuilder builder, @Nullable MapperOptions options, String keyspace, CassandraSinkBaseConfig config, CassandraFailureHandler failureHandler) {
        super(builder, config, failureHandler);
        this.clazz = clazz;
        this.options = options;
        this.keyspace = keyspace;
    }

    @Override
    public void open(Configuration configuration) {
        super.open(configuration);
        try {
            Mapper.Option[] optionsArray;
            this.mappingManager = new MappingManager(this.session);
            this.mapper = this.mappingManager.mapper(this.clazz);
            if (this.options != null && (optionsArray = this.options.getMapperOptions()) != null) {
                this.mapper.setDefaultSaveOptions(optionsArray);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create CassandraPojoSink with input: " + this.clazz.getSimpleName(), e);
        }
    }

    @Override
    protected Session createSession() {
        return this.cluster.connect(this.keyspace);
    }

    @Override
    public ListenableFuture<ResultSet> send(IN value) {
        return this.session.executeAsync(this.mapper.saveQuery(value));
    }
}

