/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import org.apache.flink.streaming.connectors.cassandra.AbstractCassandraTupleSink;
import org.apache.flink.streaming.connectors.cassandra.CassandraFailureHandler;
import org.apache.flink.streaming.connectors.cassandra.CassandraSinkBaseConfig;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.connectors.cassandra.NoOpCassandraFailureHandler;
import org.apache.flink.types.Row;

public class CassandraRowSink
extends AbstractCassandraTupleSink<Row> {
    private final int rowArity;

    public CassandraRowSink(int rowArity, String insertQuery, ClusterBuilder builder) {
        this(rowArity, insertQuery, builder, CassandraSinkBaseConfig.newBuilder().build());
    }

    CassandraRowSink(int rowArity, String insertQuery, ClusterBuilder builder, CassandraSinkBaseConfig config) {
        this(rowArity, insertQuery, builder, config, new NoOpCassandraFailureHandler());
    }

    CassandraRowSink(int rowArity, String insertQuery, ClusterBuilder builder, CassandraSinkBaseConfig config, CassandraFailureHandler failureHandler) {
        super(insertQuery, builder, config, failureHandler);
        this.rowArity = rowArity;
    }

    @Override
    protected Object[] extract(Row record) {
        Object[] al = new Object[this.rowArity];
        for (int i = 0; i < this.rowArity; ++i) {
            al[i] = record.getField(i);
        }
        return al;
    }
}

