/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import java.io.Serializable;
import java.time.Duration;
import org.apache.flink.util.Preconditions;

public final class CassandraSinkBaseConfig
implements Serializable {
    public static final int DEFAULT_MAX_CONCURRENT_REQUESTS = Integer.MAX_VALUE;
    public static final Duration DEFAULT_MAX_CONCURRENT_REQUESTS_TIMEOUT = Duration.ofMillis(Long.MAX_VALUE);
    public static final boolean DEFAULT_IGNORE_NULL_FIELDS = false;
    private final int maxConcurrentRequests;
    private final Duration maxConcurrentRequestsTimeout;
    private final boolean ignoreNullFields;

    private CassandraSinkBaseConfig(int maxConcurrentRequests, Duration maxConcurrentRequestsTimeout, boolean ignoreNullFields) {
        Preconditions.checkArgument((maxConcurrentRequests > 0 ? 1 : 0) != 0, (Object)"Max concurrent requests is expected to be positive");
        Preconditions.checkNotNull((Object)maxConcurrentRequestsTimeout, (String)"Max concurrent requests timeout cannot be null");
        Preconditions.checkArgument((!maxConcurrentRequestsTimeout.isNegative() ? 1 : 0) != 0, (Object)"Max concurrent requests timeout is expected to be positive");
        this.maxConcurrentRequests = maxConcurrentRequests;
        this.maxConcurrentRequestsTimeout = maxConcurrentRequestsTimeout;
        this.ignoreNullFields = ignoreNullFields;
    }

    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    public Duration getMaxConcurrentRequestsTimeout() {
        return this.maxConcurrentRequestsTimeout;
    }

    public boolean getIgnoreNullFields() {
        return this.ignoreNullFields;
    }

    public String toString() {
        return "CassandraSinkBaseConfig{maxConcurrentRequests=" + this.maxConcurrentRequests + ", maxConcurrentRequestsTimeout=" + this.maxConcurrentRequestsTimeout + ", ignoreNullFields=" + this.ignoreNullFields + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private int maxConcurrentRequests = Integer.MAX_VALUE;
        private Duration maxConcurrentRequestsTimeout = DEFAULT_MAX_CONCURRENT_REQUESTS_TIMEOUT;
        private boolean ignoreNullFields = false;

        Builder() {
        }

        public Builder setMaxConcurrentRequests(int maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return this;
        }

        public Builder setMaxConcurrentRequestsTimeout(Duration timeout) {
            this.maxConcurrentRequestsTimeout = timeout;
            return this;
        }

        public Builder setIgnoreNullFields(boolean ignoreNullFields) {
            this.ignoreNullFields = ignoreNullFields;
            return this;
        }

        public CassandraSinkBaseConfig build() {
            return new CassandraSinkBaseConfig(this.maxConcurrentRequests, this.maxConcurrentRequestsTimeout, this.ignoreNullFields);
        }
    }
}

