/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.FutureCallback;
import org.apache.flink.cassandra.shaded.com.google.common.util.concurrent.Futures;
import org.apache.flink.streaming.connectors.cassandra.ClusterBuilder;
import org.apache.flink.streaming.runtime.operators.CheckpointCommitter;
import org.apache.flink.streaming.runtime.operators.GenericWriteAheadSink;

public class CassandraTupleWriteAheadSink<IN extends Tuple>
extends GenericWriteAheadSink<IN> {
    private static final long serialVersionUID = 1L;
    protected transient Cluster cluster;
    protected transient Session session;
    private final String insertQuery;
    private transient PreparedStatement preparedStatement;
    private ClusterBuilder builder;
    private transient Object[] fields;

    protected CassandraTupleWriteAheadSink(String insertQuery, TypeSerializer<IN> serializer, ClusterBuilder builder, CheckpointCommitter committer) throws Exception {
        super(committer, serializer, UUID.randomUUID().toString().replace("-", "_"));
        this.insertQuery = insertQuery;
        this.builder = builder;
        ClosureCleaner.clean((Object)builder, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
    }

    public void open() throws Exception {
        super.open();
        if (!this.getRuntimeContext().isCheckpointingEnabled()) {
            throw new IllegalStateException("The write-ahead log requires checkpointing to be enabled.");
        }
        this.cluster = this.builder.getCluster();
        this.session = this.cluster.connect();
        this.preparedStatement = this.session.prepare(this.insertQuery);
        this.fields = new Object[((TupleSerializer)this.serializer).getArity()];
    }

    public void close() throws Exception {
        super.close();
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while closing session.", (Throwable)e);
        }
        try {
            if (this.cluster != null) {
                this.cluster.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error while closing cluster.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendValues(Iterable<IN> values, long checkpointId, long timestamp) throws Exception {
        final AtomicInteger updatesCount = new AtomicInteger(0);
        final AtomicInteger updatesConfirmed = new AtomicInteger(0);
        final AtomicReference exception = new AtomicReference();
        FutureCallback<ResultSet> callback = new FutureCallback<ResultSet>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(ResultSet resultSet) {
                updatesConfirmed.incrementAndGet();
                if (updatesCount.get() > 0 && updatesCount.get() == updatesConfirmed.get()) {
                    AtomicInteger atomicInteger = updatesConfirmed;
                    synchronized (atomicInteger) {
                        updatesConfirmed.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Throwable throwable) {
                if (exception.compareAndSet(null, throwable)) {
                    LOG.error("Error while sending value.", throwable);
                    AtomicInteger atomicInteger = updatesConfirmed;
                    synchronized (atomicInteger) {
                        updatesConfirmed.notifyAll();
                    }
                }
            }
        };
        int updatesSent = 0;
        for (Tuple value : values) {
            for (int x = 0; x < value.getArity(); ++x) {
                this.fields[x] = value.getField(x);
            }
            BoundStatement s = this.preparedStatement.bind(this.fields);
            s.setDefaultTimestamp(timestamp);
            ResultSetFuture result = this.session.executeAsync(s);
            ++updatesSent;
            if (result == null) continue;
            Futures.addCallback(result, callback);
        }
        updatesCount.set(updatesSent);
        AtomicInteger atomicInteger = updatesConfirmed;
        synchronized (atomicInteger) {
            while (exception.get() == null && updatesSent != updatesConfirmed.get()) {
                updatesConfirmed.wait();
            }
        }
        if (exception.get() != null) {
            LOG.warn("Sending a value failed.", (Throwable)exception.get());
            return false;
        }
        return true;
    }
}

