/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.rabbitmq;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.connectors.rabbitmq.RMQSinkPublishOptions;
import org.apache.flink.streaming.connectors.rabbitmq.SerializableReturnListener;
import org.apache.flink.streaming.connectors.rabbitmq.common.RMQConnectionConfig;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQSink<IN>
extends RichSinkFunction<IN> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RMQSink.class);
    @Nullable
    protected final String queueName;
    private final RMQConnectionConfig rmqConnectionConfig;
    protected transient Connection connection;
    protected transient Channel channel;
    protected SerializationSchema<IN> schema;
    private boolean logFailuresOnly = false;
    @Nullable
    private final RMQSinkPublishOptions<IN> publishOptions;
    @Nullable
    private final SerializableReturnListener returnListener;

    private RMQSink(RMQConnectionConfig rmqConnectionConfig, @Nullable String queueName, SerializationSchema<IN> schema, @Nullable RMQSinkPublishOptions<IN> publishOptions, @Nullable SerializableReturnListener returnListener) {
        this.rmqConnectionConfig = rmqConnectionConfig;
        this.queueName = queueName;
        this.schema = schema;
        this.publishOptions = publishOptions;
        this.returnListener = returnListener;
    }

    @PublicEvolving
    public RMQSink(RMQConnectionConfig rmqConnectionConfig, String queueName, SerializationSchema<IN> schema) {
        this(rmqConnectionConfig, queueName, schema, null, null);
    }

    @PublicEvolving
    public RMQSink(RMQConnectionConfig rmqConnectionConfig, SerializationSchema<IN> schema, RMQSinkPublishOptions<IN> publishOptions) {
        this(rmqConnectionConfig, null, schema, publishOptions, null);
    }

    @PublicEvolving
    public RMQSink(RMQConnectionConfig rmqConnectionConfig, SerializationSchema<IN> schema, RMQSinkPublishOptions<IN> publishOptions, SerializableReturnListener returnListener) {
        this(rmqConnectionConfig, null, schema, publishOptions, returnListener);
    }

    protected void setupQueue() throws IOException {
        if (this.queueName != null) {
            this.channel.queueDeclare(this.queueName, false, false, false, null);
        }
    }

    public void setLogFailuresOnly(boolean logFailuresOnly) {
        this.logFailuresOnly = logFailuresOnly;
    }

    public void open(Configuration config) throws Exception {
        ConnectionFactory factory = this.rmqConnectionConfig.getConnectionFactory();
        try {
            this.connection = factory.newConnection();
            this.channel = this.connection.createChannel();
            if (this.channel == null) {
                throw new RuntimeException("None of RabbitMQ channels are available");
            }
            this.setupQueue();
            if (this.returnListener != null) {
                this.channel.addReturnListener((ReturnListener)this.returnListener);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while creating the channel", e);
        }
    }

    public void invoke(IN value) {
        try {
            byte[] msg = this.schema.serialize(value);
            if (this.publishOptions == null) {
                this.channel.basicPublish("", this.queueName, null, msg);
            } else {
                boolean mandatory = this.publishOptions.computeMandatory(value);
                boolean immediate = this.publishOptions.computeImmediate(value);
                Preconditions.checkState((this.returnListener != null || !mandatory && !immediate ? 1 : 0) != 0, (Object)"Setting mandatory and/or immediate flags to true requires a ReturnListener.");
                String rk = this.publishOptions.computeRoutingKey(value);
                String exchange = this.publishOptions.computeExchange(value);
                this.channel.basicPublish(exchange, rk, mandatory, immediate, this.publishOptions.computeProperties(value), msg);
            }
        }
        catch (IOException e) {
            if (this.logFailuresOnly) {
                LOG.error("Cannot send RMQ message {} at {}", new Object[]{this.queueName, this.rmqConnectionConfig.getHost(), e});
            }
            throw new RuntimeException("Cannot send RMQ message " + this.queueName + " at " + this.rmqConnectionConfig.getHost(), e);
        }
    }

    public void close() {
        Exception t = null;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (IOException | TimeoutException e) {
            t = e;
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (IOException e) {
            if (t != null) {
                LOG.warn("Both channel and connection closing failed. Logging channel exception and failing with connection exception", (Throwable)t);
            }
            t = e;
        }
        if (t != null) {
            throw new RuntimeException("Error while closing RMQ connection with " + this.queueName + " at " + this.rmqConnectionConfig.getHost(), t);
        }
    }
}

