/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;

public class CheckpointingOptions {
    @Documentation.CommonOption(position=30)
    public static final ConfigOption<String> STATE_BACKEND = ConfigOptions.key("state.backend").noDefaultValue().withDescription("The state backend to be used to store and checkpoint state.");
    public static final ConfigOption<Integer> MAX_RETAINED_CHECKPOINTS = ConfigOptions.key("state.checkpoints.num-retained").defaultValue(1).withDescription("The maximum number of completed checkpoints to retain.");
    public static final ConfigOption<Boolean> ASYNC_SNAPSHOTS = ConfigOptions.key("state.backend.async").defaultValue(true).withDescription("Option whether the state backend should use an asynchronous snapshot method where possible and configurable. Some state backends may not support asynchronous snapshots, or only support asynchronous snapshots, and ignore this option.");
    public static final ConfigOption<Boolean> INCREMENTAL_CHECKPOINTS = ConfigOptions.key("state.backend.incremental").defaultValue(false).withDescription("Option whether the state backend should create incremental checkpoints, if possible. For an incremental checkpoint, only a diff from the previous checkpoint is stored, rather than the complete checkpoint state. Some state backends may not support incremental checkpoints and ignore this option.");
    public static final ConfigOption<Boolean> LOCAL_RECOVERY = ConfigOptions.key("state.backend.local-recovery").defaultValue(false);
    public static final ConfigOption<String> LOCAL_RECOVERY_TASK_MANAGER_STATE_ROOT_DIRS = ConfigOptions.key("taskmanager.state.local.root-dirs").noDefaultValue();
    @Documentation.CommonOption(position=30)
    public static final ConfigOption<String> SAVEPOINT_DIRECTORY = ConfigOptions.key("state.savepoints.dir").noDefaultValue().withDeprecatedKeys("savepoints.state.backend.fs.dir").withDescription("The default directory for savepoints. Used by the state backends that write savepoints to file systems (MemoryStateBackend, FsStateBackend, RocksDBStateBackend).");
    @Documentation.CommonOption(position=30)
    public static final ConfigOption<String> CHECKPOINTS_DIRECTORY = ConfigOptions.key("state.checkpoints.dir").noDefaultValue().withDeprecatedKeys("state.backend.fs.checkpointdir").withDescription("The default directory used for storing the data files and meta data of checkpoints in a Flink supported filesystem. The storage path must be accessible from all participating processes/nodes(i.e. all TaskManagers and JobManagers).");
    public static final ConfigOption<Integer> FS_SMALL_FILE_THRESHOLD = ConfigOptions.key("state.backend.fs.memory-threshold").defaultValue(1024).withDescription("The minimum size of state data files. All state chunks smaller than that are stored inline in the root checkpoint metadata file.");
}

